(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    179264,       5023]*)
(*NotebookOutlinePosition[    180350,       5058]*)
(*  CellTagsIndexPosition[    180306,       5054]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Quantum Teleportation", "Title",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Colin P. Williams", "Subsubtitle",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{340, 104},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005D0000J1000`40O003h00OogooEGoo003oOomE
Ool00?mooeEoo`00B7oo0P0000Aoo`00001oo`T00003Ool0000000=oo`<009=oo`D0009oo`80009o
o`<005=oo`00BGoo0`000goo00<007ooOol00Woo00@007ooOol0009oo`03001oo`0009Moo`06001o
ogoo001oo`000Woo00<007oo00000Woo00<007ooOol0D7oo0019Ool00`00Ool00003Ool00`00Oomo
o`02Ool01000Oomoo`000Woo00<007oo00000`00U7oo100000Moo`00Oomoo`00Ool00002Ool00`00
Oomoo`1@Ool004Yoo`8000=oo`04001oogooOol20003Ool30002Ool2002EOol01000Oomoo`000Woo
0P000Woo0`00Dgoo0019Ool20004Ool00`00Oomoo`2QOol50006Ool00`00Oomoo`1COol004ioo`80
00Aoo`03001oogoo0:Ioo`8005Eoo`00ogooEGoo003oOomEOol001Ioo`<000=oo`@0009oo`D0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@002Yoo`@0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@000=oo`@0009oo`D0009oo`@001aoo`005Woo00<007ooOol0Xgoo00<007ooOol0UGoo
000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03
001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yoo`03001oogoo01Qoo`005Woo00<007ooOol0
NWoo00<007ooOol09Woo00<007ooOol0A7oo4@009Goo00<007ooOol067oo002COol00`00Oomoo`1]
Ool00`00Oomoo`0=Ool00`00Oomoo`0SOol00`00Oomoo`0HOol0045oo`H004aoo`03001oogoo031o
o`H003Moo`03001oogoo00eoo`03001oogoo02=oo`03001oogoo01Qoo`005Woo00<007ooOol09goo
00D007ooOomoo`00009oo`8007=oo`03001oogoo00Ioo`05001oogooOol00002Ool2000eOol00`00
Oomoo`0=Ool00`00Oomoo`0nOol001Ioo`03001oogoo02Ioo`03001oogoo009oo`03001oogoo009o
o`03001oogoo071oo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo039o
o`03001oogoo00eoo`03001oogoo03ioo`000Woo00<007ooOol04Goo00<007ooOol09Woo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol09Woo00<007ooOol01Goo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0<Woo00<007ooOol03Goo00<007ooOol08goo00<007oo
Ool01Goo00<007ooOol047oo0002Ool00`00Oomoo`0AOol00`00Oomoo`0UOol00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0VOol00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`0FOol4000GOol00`00Oomoo`0=Ool00`00Oomoo`0EOol4000:Ool0
0`00Oomoo`05Ool01@00Oomoogoo00003Woo0002Ool00`00Oomoo`0iOol00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0]Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`0EOol6000FOol00`00Oomoo`02Ool50006Ool00`00Oomoo`0DOol60009Ool00`00Oomoo`05
Ool01@00Oomoogoo00003Woo0002Ool01000Ool000000Woo0P00<goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol0AWoo00<007ooOol0;7oo00<007ooOol017oo00<007ooOol00goo00<007oo
Ool05Goo1P005Woo00<007ooOol017oo00<007ooOol01Woo00<007ooOol057oo1P002Goo00<007oo
Ool01Goo00<007ooOol00`000Woo0P002Goo0002Ool20002Ool01000Oomoogoo0P001WoolP001Woo
00<007ooOol01Woo:`000goo00L007oo001oo`00Ool00003Ool20007Ool0009oo`80009oo`03001o
ogoo00=oo`03001oogoo00Moo`03001oogoo02Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001o
ogoo06moo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo01Eoo`H001Io
o`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo01Aoo`H0015oo`07001oo`00Ool007oo0000
1Goo00<007ooOol017oo0002Ool20002Ool01000Oomoogoo0P002Woo00<007ooOol097oo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol0Kgoo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol05Woo10005goo00D007ooOomoo`00009oo`04001oogoo0005Ool00`00Oomo
o`0EOol4000BOol01`00Ool007oo001oo`0000=oo`8000Moo`000Woo0P000Woo00@007oo000000ao
o`03001oogoo02Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo04Ioo`03001oogoo00Eo
o`03001oogoo01ioo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo01Qo
o`03001oogoo01Ioo`05001oogooOol00002Ool01000Oomoo`001Goo00<007ooOol05Woo00<007oo
Ool02Woo00<007ooOol01Goo0`0000Eoo`00Ool007oo008000Uoo`000Woo0P000Woo00<007ooOol0
3Goo00<007ooOol09Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol0
1Goo00<007ooOol07Woo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
6Goo00<007ooOol05Woo00@007ooOomoo`L000Eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001o
ogoo00Eoo`05001oogooOol0000>Ool0009oo`04001oo`00000jOol01@00Oomoogoo00000Woo0P00
BWoo00<007ooOol01Goo0`009goo00D007ooOomoo`00009oo`8001aoo`03001oogoo01Ioo`03001o
ogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011oo`000Woo
00<007ooOol0?7oo1P00C7oo00<007ooOol01Goo00@007ooOol002Moo`H001ioo`03001oogoo01Io
o`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011o
o`005Woo00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo01Ioo`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo02Eoo`005Woo
00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001oogoo01io
o`03001oogoo01Iooa4001Qoo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo
00<007ooOol01Woo0P007Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo000FOol00`00Oomoo`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol0
0`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`00A7oo00<007ooOol0C7oo00<0
07ooOol0<goo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014
Ool00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:
Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo07Eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo03moo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo
00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomo
o`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo04aoo`03
001oogoo02Ioo`03001oogoo00Yoo`03001oogoo01ioo`03001oogoo03moo`03001oogoo00Yoo`03
001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo00<007ooOol09Woo00<007ooOol0
2Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014Ool00`00
Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`0HOol004Aoo`03001oogoo04aoo`03001oogoo03=oo`03001oogoo01ioo`03001oogoo03mo
o`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo00<007oo
Ool02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`0[Ool0
0`00Oomoo`1eOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0UOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<0
07ooOol0C7oo00<007ooOol09Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<0
07ooOol02Woo00<007ooOol067oo000JOolB000HOol00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00
Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Yoo`03001oogoo00io
o`03001oogoo01Ioo`03001oogoo01eoo`@002]oo`03001oogoo03=oo`03001oogoo01ioo`03001o
ogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`006Woo00<007ooOol03Woo00<007ooOol05Woo
00<007ooOol06goo0P0000Eoo`00Oomoo`00061oo`03001oogoo01ioo`03001oogoo03moo`03001o
ogoo02Eoo`005Woo00D007ooOomoo`00011oo`03001oogoo01Ioo`03001oogoo01Uoo`8000=oo`05
001oogooOol0001BOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0U
Ool0009oo`03001oogoo015oo`05001oogooOol0000@Ool00`00Oomoo`0FOol00`00Oomoo`0IOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1?Ool00`00Oomoo`0:Ool00`00Oomoo`0NOol0
0`00Oomoo`0oOol00`00Oomoo`0BOol00`00Oomoo`0@Ool0009oo`03001oogoo015oo`05001oogoo
Ool0000@Ool00`00Oomoo`0DOol4000IOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0V
Ool00`00Oomoo`0VOol00`00Oomoo`08Ool4000OOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0AOol01@00Oomoogoo00001Goo1P001Goo
00<007ooOol04goo1P0067oo00<007ooOol00goo00<007ooOol00goo00<007ooOol09Goo00<007oo
Ool09Woo00<007ooOol01goo1P007Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol01Goo
00@007ooOol000moo`000Woo00@007oo0000009oo`80011oo`03001oogoo00Aoo`05001oogooOol0
0005Ool00`00Oomoo`0COol6000GOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0UOol0
0`00Oomoo`06Ool00`00Oomoo`0WOol6000NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool00`00Ool0000200000goo0000000;Ool0009oo`80009oo`04001oogooOol20006Ool90006
Ool01@00Oomoogoo00001GooK@0087ooQP000goo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0P00
0Woo00<007ooOol00goo00<007ooOol01goo00D007ooOomoo`0000Ioo`03001oogoo00Moo`03001o
ogoo01=oo`H001Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo04eoo`03001oogoo00Mo
o`H001ioo`03001oogoo03moo`03001oogoo019oo`800004Ool007oo0004Ool00`00Oomoo`06Ool0
009oo`80009oo`04001oogooOol2000:Ool01@00Oomoogoo00001Woo00<007ooOol01goo00<007oo
Ool057oo10006Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0;Woo00<007ooOol07Goo
00<007ooOol027oo10007goo00<007ooOol0?goo00<007ooOol04Woo0P0000Aoo`00Ool0009oo`80
00Uoo`000Woo0P000Woo00@007oo000000aoo`05001oogooOol00006Ool00`00Oomoo`07Ool00`00
Oomoo`0aOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomoo`07Ool00`00
Oomoo`0LOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00
Ool0000200000goo0000000;Ool0009oo`80009oo`03001oogoo00eoo`05001oogooOol00005Ool4
0007Ool00`00Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomo
o`05Ool00`00Ool0000NOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool01000Oomoo`003goo0002Ool01000Ool0000047oo00D007ooOomoo`00011oo`03001oogoo
039oo`8000=oo`04001oogooOol2000XOol00`00Oomoo`05Ool3000NOol00`00Oomoo`0[Ool00`00
Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0E
Ool00`00Oomoo`0>Ool00`00Oomoo`0UOol3000<Ool7000ZOol00`00Oomoo`1DOol00`00Oomoo`0o
Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool001Yoo`03001oogoo00ioo`03001o
ogoo02Aoo`05001oogooOol0000>Ool00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`04001oogooOolB000VOol01@00Oomoogoo00003Woo
00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0iOol01@00Oomoogoo00003Woo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`0jOol5000=Ool00`00Oomoo`0[Ool00`00Oomoo`0VOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo04ao
o`03001oogoo02]oo`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yo
o`03001oogoo01Qoo`00IGoo00<007ooOol0:goo00<007ooOol0E7oo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo089oo`03001oogoo03moo`03001oogoo
02Eoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00Oomoo`0[Ool00`00Oomoo`0o
Ool00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]oo`03001oogoo02Ioo`03001o
ogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo
00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol02Woo
00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol00`00Oomo
o`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo02]oo`03001oogoo05Aoo`03001oogoo03moo`03
001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0
:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]o
o`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qo
o`005Woo00<007ooOol0C7oo00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007oo
Ool0?goo00<007ooOol02Woo00<007ooOol067oo000FOol00`00Oomoo`1<Ool00`00Oomoo`0FOolA
0004Ool00`00Oomoo`0VOol01000Oomoogoo4P0067oo00<007ooOol05Woo4@0067oo00<007ooOol0
2Woo00<007ooOol067oo001UOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0FOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00
Oomoo`0FOol00`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo01Ioo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo02Yoo`03001oogoo00ioo`03001oogoo01=oo`L001Eoo`03001o
ogoo00eoo`03001oogoo01=oo`L000Uoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007oo
Ool05Woo00<007ooOol03Goo00<007ooOol0:goo00D007ooOomoo`00011oo`03001oogoo015oo`80
00=oo`05001oogooOol0000DOol00`00Oomoo`0=Ool00`00Oomoo`0BOol01@00Oomoogoo00000goo
00<007ooOol08Goo0002Ool00`00Oomoo`0AOol00`00Oomoo`1<Ool00`00Oomoo`0FOol00`00Oomo
o`0=Ool00`00Oomoo`0[Ool01@00Oomoogoo000047oo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol04Goo00<007ooOol03Goo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol047oo0002Ool01@00Oomoogoo00003goo00<007oo
Ool0C7oo00<007ooOol05Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol09Woo00D007oo
Oomoo`00011oo`03001oogoo011oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo015oo`03
001oogoo00eoo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`03
001oogoo00Eoo`04001oogoo000?Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1:Ool4000G
Ool01000Oomoogoo0`000Woo0P001Goo00<007ooOol00Woo00<007ooOol09Woo00D007ooOomoo`00
00Eoo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03
001oogoo009oo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo00<0009oo`8005Ioo`H001Io
o`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`0QOol00`00Oomoo`03Ool01@00Oomoogoo00001Woo00<007ooOol03goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol047oo00<007ooOol00Woo00D007ooOomoo`0000Ioo`03001oogoo011o
o`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00Eoo`03001oo`000080
0003Ool0000000]oo`000Woo00L007oo001oo`00Ool00003Ool20004Oom]0004Ool01000Oomoo`00
1goo2P0087oo2@002Goo00<007ooOol017oo<`0027oo00<007ooOol017oo:`000goo0P0000Aoo`00
Ool0009oo`8000Uoo`000Woo00L007oo001oo`00Ool00005Ool00`00Oomoo`1AOol6000FOol00`00
Oomoo`02Ool40007Ool00`00Oomoo`0_Ool00`00Oomoo`04Ool30007Ool00`00Oomoo`0?Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool30007Ool00`00Oomoo`0@
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool2000017oo001oo`0017oo00<007oo
Ool01Woo0002Ool01`00Ool007oo001oo`0000=oo`8000Qoo`03001oogoo04Uoo`H001Ioo`03001o
ogoo009oo`05001oogooOol00006Ool00`00Oomoo`0;Ool00`00Oomoo`0MOol01@00Oomoogoo0000
1Goo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
47oo00<007ooOol00Woo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol037oo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0`0000Eoo`00Ool007oo0080
00Yoo`03001oogoo04Yoo`@001Moo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`0<
Ool00`00Oomoo`0LOol01@00Oomoogoo00001Goo00D007ooOomoo`0000Ioo`03001oogoo011oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03001oogoo009oo`05001oogooOol00006
Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0<Ool00`00Ool00002
00000goo0000000;Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1UOol01000Oomoogoo1@00
1goo00<007ooOol00Woo00<007ooOol01Goo00<007oo00007Woo00D007ooOomoo`0000Ioo`@000Io
o`03001oogoo015oo`03001oogoo009oo`03001oogoo009oo`03001oogoo015oo`03001oogoo00=o
o`@000Ioo`03001oogoo015oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo015oo`03001oogoo06Eoo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo00Eoo`<001ioo`05001oogooOol0000@Ool00`00Oomoo`0AOol2
0003Ool00`00Oomoo`02000DOol00`00Oomoo`0=Ool00`00Oomoo`0AOol30002Ool01000Oomoogoo
0P001goo00<007ooOol01Goo00@007ooOol000moo`000Woo00<007ooOol0NGoo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0:Woo00<007ooOol03Woo00<007ooOol04goo1P005Woo00<007oo
Ool03Goo00<007ooOol057oo0`0000=oo`0000002Goo00<007ooOol01Goo00<007ooOol047oo001n
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0F
Ool00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`0FOol2000;Ool00`00Oomoo`0HOol007io
o`03001oogoo00eoo`03001oogoo02moo`03001oogoo00ioo`03001oogoo02moo`03001oogoo00eo
o`03001oogoo03ioo`005Woo00<007ooOol0IGoo4@00;Goo00@007ooOomooa80035ooa40041oo`00
5Woo00<007ooOol0Xgoo00<007ooOol0UGoo000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00
Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yo
o`03001oogoo01Qoo`006Goo10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000goo
10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo
10000Woo0`00:goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo
1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo
0`006Woo0000\
\>"],
  ImageRangeCache->{{{0, 339}, {103, 0}} -> {-0.551496, -0.700015, 0.0300973, 
  0.0300973}}],

Cell[BoxData[
    \(Off[General::spell1]\)], "Input",
  Editable->False],

Cell[CellGroupData[{

Cell["Copyright Notice", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with \"Explorations in \
Quantum Computing\" by Colin P. Williams and Scott H. Clearwater, TELOS, \
Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to \
copy and distribute this Notebook freely for any non-commercial activity \
provided you include this copyright notice at the beginning of all such \
copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on \"Explorations in Quantum Computing\" check out the TELOS \
web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To \
order call 1-800-777-4643.

All other rights reserved.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction to Teleportation", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
This Notebook contains code for simulating quantum teleportation of \
an arbitrary quantum state from a sender, Alice, to a receiver, Bob (see \
\"Explorations in Quantum Computing\", Chapter 9).   Unlike the science \
fiction accounts of teleportation, the mechanism that we describe is \
consistent with known physics.  Better yet, the number of operations on \
qubits that would be required to implement quantum teleportation is far less \
than the number of operations needed to implement Shor's quantum  algorithm \
for factoring large composite  integers.  As a result,  an experimental \
demonstration of quantum teleportation appears to be feasible given in the \
near future!  The \"teleportation circuit\", devised by Gilles Brassard, that \
we describe below is capable of performing all the necessary stages of \
quantum teleportation.

Prior to Alice attempting to teleport a quantum state to Bob, Alice and Bob \
must conspire to establish a kind of \"quantum communication channel\".  This \
is done by Alice creating a pair of entangled particles, shipping one member \
of the pair off to Bob and keeping the other member of the pair for herself.  \
The entangled particles serve as the two ends of an ebit.  Their states, \
although individually ambiguous, are highly correlated with one another in \
the sense that measuring one end of the ebit instantaneously determines the \
value of a similar experiment performed at the other end of the ebit.  This \
\"influence\" however does not propagate through the space separating the \
ends of the ebit in the conventional sense.  Rather there is a lingering \
correlation between the states of the particles at either end of the ebit \
that becomes manifest when either particle is measured.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
To illustrate how teleportation might work, we begin by exhibiting \
a 3 input/3 output quantum circuit that is capable of transferring an \
arbitrary quantum state from the top line of the input to the bottom line of \
the output.  However this transfer of state does not constitute \
teleportation, as the circuit is intact. We then severe the connections \
between two of the three lines in the middle of the circuit and replace the \
literal states that would have been transmitted with the results of measuring \
the states on those lines.  We no longer have a quantum circuit but instead \
we have a mutilated quantum circuit. Remarkably, despite the profound \
disturbance this causes to the states passing through the circuit, it is \
still possible to re-incarnate the original state that was on the top line of \
the input on the bottom line of the output.  However the original input state \
is destroyed in this process.  By a careful dissection of the mutilated \
circuit, we can see that the operations performed are analogous to the stages \
of teleportation.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Brassard's Teleportation \"Circuit\"", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Below we describe a simulation of the operation of a teleportation \
\"circuit\" devised by Canadian computer scientist Gilles Brassard.   This is \
not a circuit in the usual sense because some of the lines passing through \
the circuit are actually severed.  It is better to think of the \"circuit\" \
as a design for a sequence of operations that will succeed in teleporting an \
unknown state on the top line of the input to the bottom line of the output.  \
However, this state does not pass through the circuit in the conventional \
sense but rather the information in the unknown state is disassembled into a \
classical part and a quantum part, the two parts are transmitted through \
separate channels and re-combined by the receiver, Bob, to re-incarnate the \
original state.  Here is a sketch of the \"circuit\".  We will explain its \
composition, and how it works, shortly.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{340, 104},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005D0000J1000`40O003h00OogooEGoo003oOomE
Ool00?mooeEoo`00B7oo0P0000Aoo`00001oo`T00003Ool0000000=oo`<009=oo`D0009oo`80009o
o`<005=oo`00BGoo0`000goo00<007ooOol00Woo00@007ooOol0009oo`03001oo`0009Moo`06001o
ogoo001oo`000Woo00<007oo00000Woo00<007ooOol0D7oo0019Ool00`00Ool00003Ool00`00Oomo
o`02Ool01000Oomoo`000Woo00<007oo00000`00U7oo100000Moo`00Oomoo`00Ool00002Ool00`00
Oomoo`1@Ool004Yoo`8000=oo`04001oogooOol20003Ool30002Ool2002EOol01000Oomoo`000Woo
0P000Woo0`00Dgoo0019Ool20004Ool00`00Oomoo`2QOol50006Ool00`00Oomoo`1COol004ioo`80
00Aoo`03001oogoo0:Ioo`8005Eoo`00ogooEGoo003oOomEOol001Ioo`<000=oo`@0009oo`D0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@002Yoo`@0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@000=oo`@0009oo`D0009oo`@001aoo`005Woo00<007ooOol0Xgoo00<007ooOol0UGoo
000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03
001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yoo`03001oogoo01Qoo`005Woo00<007ooOol0
NWoo00<007ooOol09Woo00<007ooOol0A7oo4@009Goo00<007ooOol067oo002COol00`00Oomoo`1]
Ool00`00Oomoo`0=Ool00`00Oomoo`0SOol00`00Oomoo`0HOol0045oo`H004aoo`03001oogoo031o
o`H003Moo`03001oogoo00eoo`03001oogoo02=oo`03001oogoo01Qoo`005Woo00<007ooOol09goo
00D007ooOomoo`00009oo`8007=oo`03001oogoo00Ioo`05001oogooOol00002Ool2000eOol00`00
Oomoo`0=Ool00`00Oomoo`0nOol001Ioo`03001oogoo02Ioo`03001oogoo009oo`03001oogoo009o
o`03001oogoo071oo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo039o
o`03001oogoo00eoo`03001oogoo03ioo`000Woo00<007ooOol04Goo00<007ooOol09Woo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol09Woo00<007ooOol01Goo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0<Woo00<007ooOol03Goo00<007ooOol08goo00<007oo
Ool01Goo00<007ooOol047oo0002Ool00`00Oomoo`0AOol00`00Oomoo`0UOol00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0VOol00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`0FOol4000GOol00`00Oomoo`0=Ool00`00Oomoo`0EOol4000:Ool0
0`00Oomoo`05Ool01@00Oomoogoo00003Woo0002Ool00`00Oomoo`0iOol00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0]Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`0EOol6000FOol00`00Oomoo`02Ool50006Ool00`00Oomoo`0DOol60009Ool00`00Oomoo`05
Ool01@00Oomoogoo00003Woo0002Ool01000Ool000000Woo0P00<goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol0AWoo00<007ooOol0;7oo00<007ooOol017oo00<007ooOol00goo00<007oo
Ool05Goo1P005Woo00<007ooOol017oo00<007ooOol01Woo00<007ooOol057oo1P002Goo00<007oo
Ool01Goo00<007ooOol00`000Woo0P002Goo0002Ool20002Ool01000Oomoogoo0P001WoolP001Woo
00<007ooOol01Woo:`000goo00L007oo001oo`00Ool00003Ool20007Ool0009oo`80009oo`03001o
ogoo00=oo`03001oogoo00Moo`03001oogoo02Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001o
ogoo06moo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo01Eoo`H001Io
o`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo01Aoo`H0015oo`07001oo`00Ool007oo0000
1Goo00<007ooOol017oo0002Ool20002Ool01000Oomoogoo0P002Woo00<007ooOol097oo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol0Kgoo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol05Woo10005goo00D007ooOomoo`00009oo`04001oogoo0005Ool00`00Oomo
o`0EOol4000BOol01`00Ool007oo001oo`0000=oo`8000Moo`000Woo0P000Woo00@007oo000000ao
o`03001oogoo02Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo04Ioo`03001oogoo00Eo
o`03001oogoo01ioo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo01Qo
o`03001oogoo01Ioo`05001oogooOol00002Ool01000Oomoo`001Goo00<007ooOol05Woo00<007oo
Ool02Woo00<007ooOol01Goo0`0000Eoo`00Ool007oo008000Uoo`000Woo0P000Woo00<007ooOol0
3Goo00<007ooOol09Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol0
1Goo00<007ooOol07Woo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
6Goo00<007ooOol05Woo00@007ooOomoo`L000Eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001o
ogoo00Eoo`05001oogooOol0000>Ool0009oo`04001oo`00000jOol01@00Oomoogoo00000Woo0P00
BWoo00<007ooOol01Goo0`009goo00D007ooOomoo`00009oo`8001aoo`03001oogoo01Ioo`03001o
ogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011oo`000Woo
00<007ooOol0?7oo1P00C7oo00<007ooOol01Goo00@007ooOol002Moo`H001ioo`03001oogoo01Io
o`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011o
o`005Woo00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo01Ioo`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo02Eoo`005Woo
00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001oogoo01io
o`03001oogoo01Iooa4001Qoo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo
00<007ooOol01Woo0P007Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo000FOol00`00Oomoo`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol0
0`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`00A7oo00<007ooOol0C7oo00<0
07ooOol0<goo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014
Ool00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:
Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo07Eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo03moo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo
00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomo
o`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo04aoo`03
001oogoo02Ioo`03001oogoo00Yoo`03001oogoo01ioo`03001oogoo03moo`03001oogoo00Yoo`03
001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo00<007ooOol09Woo00<007ooOol0
2Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014Ool00`00
Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`0HOol004Aoo`03001oogoo04aoo`03001oogoo03=oo`03001oogoo01ioo`03001oogoo03mo
o`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo00<007oo
Ool02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`0[Ool0
0`00Oomoo`1eOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0UOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<0
07ooOol0C7oo00<007ooOol09Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<0
07ooOol02Woo00<007ooOol067oo000JOolB000HOol00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00
Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Yoo`03001oogoo00io
o`03001oogoo01Ioo`03001oogoo01eoo`@002]oo`03001oogoo03=oo`03001oogoo01ioo`03001o
ogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`006Woo00<007ooOol03Woo00<007ooOol05Woo
00<007ooOol06goo0P0000Eoo`00Oomoo`00061oo`03001oogoo01ioo`03001oogoo03moo`03001o
ogoo02Eoo`005Woo00D007ooOomoo`00011oo`03001oogoo01Ioo`03001oogoo01Uoo`8000=oo`05
001oogooOol0001BOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0U
Ool0009oo`03001oogoo015oo`05001oogooOol0000@Ool00`00Oomoo`0FOol00`00Oomoo`0IOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1?Ool00`00Oomoo`0:Ool00`00Oomoo`0NOol0
0`00Oomoo`0oOol00`00Oomoo`0BOol00`00Oomoo`0@Ool0009oo`03001oogoo015oo`05001oogoo
Ool0000@Ool00`00Oomoo`0DOol4000IOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0V
Ool00`00Oomoo`0VOol00`00Oomoo`08Ool4000OOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0AOol01@00Oomoogoo00001Goo1P001Goo
00<007ooOol04goo1P0067oo00<007ooOol00goo00<007ooOol00goo00<007ooOol09Goo00<007oo
Ool09Woo00<007ooOol01goo1P007Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol01Goo
00@007ooOol000moo`000Woo00@007oo0000009oo`80011oo`03001oogoo00Aoo`05001oogooOol0
0005Ool00`00Oomoo`0COol6000GOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0UOol0
0`00Oomoo`06Ool00`00Oomoo`0WOol6000NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool00`00Ool0000200000goo0000000;Ool0009oo`80009oo`04001oogooOol20006Ool90006
Ool01@00Oomoogoo00001GooK@0087ooQP000goo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0P00
0Woo00<007ooOol00goo00<007ooOol01goo00D007ooOomoo`0000Ioo`03001oogoo00Moo`03001o
ogoo01=oo`H001Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo04eoo`03001oogoo00Mo
o`H001ioo`03001oogoo03moo`03001oogoo019oo`800004Ool007oo0004Ool00`00Oomoo`06Ool0
009oo`80009oo`04001oogooOol2000:Ool01@00Oomoogoo00001Woo00<007ooOol01goo00<007oo
Ool057oo10006Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0;Woo00<007ooOol07Goo
00<007ooOol027oo10007goo00<007ooOol0?goo00<007ooOol04Woo0P0000Aoo`00Ool0009oo`80
00Uoo`000Woo0P000Woo00@007oo000000aoo`05001oogooOol00006Ool00`00Oomoo`07Ool00`00
Oomoo`0aOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomoo`07Ool00`00
Oomoo`0LOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00
Ool0000200000goo0000000;Ool0009oo`80009oo`03001oogoo00eoo`05001oogooOol00005Ool4
0007Ool00`00Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomo
o`05Ool00`00Ool0000NOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool01000Oomoo`003goo0002Ool01000Ool0000047oo00D007ooOomoo`00011oo`03001oogoo
039oo`8000=oo`04001oogooOol2000XOol00`00Oomoo`05Ool3000NOol00`00Oomoo`0[Ool00`00
Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0E
Ool00`00Oomoo`0>Ool00`00Oomoo`0UOol3000<Ool7000ZOol00`00Oomoo`1DOol00`00Oomoo`0o
Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool001Yoo`03001oogoo00ioo`03001o
ogoo02Aoo`05001oogooOol0000>Ool00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`04001oogooOolB000VOol01@00Oomoogoo00003Woo
00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0iOol01@00Oomoogoo00003Woo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`0jOol5000=Ool00`00Oomoo`0[Ool00`00Oomoo`0VOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo04ao
o`03001oogoo02]oo`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yo
o`03001oogoo01Qoo`00IGoo00<007ooOol0:goo00<007ooOol0E7oo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo089oo`03001oogoo03moo`03001oogoo
02Eoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00Oomoo`0[Ool00`00Oomoo`0o
Ool00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]oo`03001oogoo02Ioo`03001o
ogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo
00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol02Woo
00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol00`00Oomo
o`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo02]oo`03001oogoo05Aoo`03001oogoo03moo`03
001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0
:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]o
o`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qo
o`005Woo00<007ooOol0C7oo00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007oo
Ool0?goo00<007ooOol02Woo00<007ooOol067oo000FOol00`00Oomoo`1<Ool00`00Oomoo`0FOolA
0004Ool00`00Oomoo`0VOol01000Oomoogoo4P0067oo00<007ooOol05Woo4@0067oo00<007ooOol0
2Woo00<007ooOol067oo001UOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0FOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00
Oomoo`0FOol00`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo01Ioo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo02Yoo`03001oogoo00ioo`03001oogoo01=oo`L001Eoo`03001o
ogoo00eoo`03001oogoo01=oo`L000Uoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007oo
Ool05Woo00<007ooOol03Goo00<007ooOol0:goo00D007ooOomoo`00011oo`03001oogoo015oo`80
00=oo`05001oogooOol0000DOol00`00Oomoo`0=Ool00`00Oomoo`0BOol01@00Oomoogoo00000goo
00<007ooOol08Goo0002Ool00`00Oomoo`0AOol00`00Oomoo`1<Ool00`00Oomoo`0FOol00`00Oomo
o`0=Ool00`00Oomoo`0[Ool01@00Oomoogoo000047oo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol04Goo00<007ooOol03Goo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol047oo0002Ool01@00Oomoogoo00003goo00<007oo
Ool0C7oo00<007ooOol05Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol09Woo00D007oo
Oomoo`00011oo`03001oogoo011oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo015oo`03
001oogoo00eoo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`03
001oogoo00Eoo`04001oogoo000?Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1:Ool4000G
Ool01000Oomoogoo0`000Woo0P001Goo00<007ooOol00Woo00<007ooOol09Woo00D007ooOomoo`00
00Eoo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03
001oogoo009oo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo00<0009oo`8005Ioo`H001Io
o`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`0QOol00`00Oomoo`03Ool01@00Oomoogoo00001Woo00<007ooOol03goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol047oo00<007ooOol00Woo00D007ooOomoo`0000Ioo`03001oogoo011o
o`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00Eoo`03001oo`000080
0003Ool0000000]oo`000Woo00L007oo001oo`00Ool00003Ool20004Oom]0004Ool01000Oomoo`00
1goo2P0087oo2@002Goo00<007ooOol017oo<`0027oo00<007ooOol017oo:`000goo0P0000Aoo`00
Ool0009oo`8000Uoo`000Woo00L007oo001oo`00Ool00005Ool00`00Oomoo`1AOol6000FOol00`00
Oomoo`02Ool40007Ool00`00Oomoo`0_Ool00`00Oomoo`04Ool30007Ool00`00Oomoo`0?Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool30007Ool00`00Oomoo`0@
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool2000017oo001oo`0017oo00<007oo
Ool01Woo0002Ool01`00Ool007oo001oo`0000=oo`8000Qoo`03001oogoo04Uoo`H001Ioo`03001o
ogoo009oo`05001oogooOol00006Ool00`00Oomoo`0;Ool00`00Oomoo`0MOol01@00Oomoogoo0000
1Goo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
47oo00<007ooOol00Woo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol037oo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0`0000Eoo`00Ool007oo0080
00Yoo`03001oogoo04Yoo`@001Moo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`0<
Ool00`00Oomoo`0LOol01@00Oomoogoo00001Goo00D007ooOomoo`0000Ioo`03001oogoo011oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03001oogoo009oo`05001oogooOol00006
Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0<Ool00`00Ool00002
00000goo0000000;Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1UOol01000Oomoogoo1@00
1goo00<007ooOol00Woo00<007ooOol01Goo00<007oo00007Woo00D007ooOomoo`0000Ioo`@000Io
o`03001oogoo015oo`03001oogoo009oo`03001oogoo009oo`03001oogoo015oo`03001oogoo00=o
o`@000Ioo`03001oogoo015oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo015oo`03001oogoo06Eoo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo00Eoo`<001ioo`05001oogooOol0000@Ool00`00Oomoo`0AOol2
0003Ool00`00Oomoo`02000DOol00`00Oomoo`0=Ool00`00Oomoo`0AOol30002Ool01000Oomoogoo
0P001goo00<007ooOol01Goo00@007ooOol000moo`000Woo00<007ooOol0NGoo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0:Woo00<007ooOol03Woo00<007ooOol04goo1P005Woo00<007oo
Ool03Goo00<007ooOol057oo0`0000=oo`0000002Goo00<007ooOol01Goo00<007ooOol047oo001n
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0F
Ool00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`0FOol2000;Ool00`00Oomoo`0HOol007io
o`03001oogoo00eoo`03001oogoo02moo`03001oogoo00ioo`03001oogoo02moo`03001oogoo00eo
o`03001oogoo03ioo`005Woo00<007ooOol0IGoo4@00;Goo00@007ooOomooa80035ooa40041oo`00
5Woo00<007ooOol0Xgoo00<007ooOol0UGoo000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00
Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yo
o`03001oogoo01Qoo`006Goo10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000goo
10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo
10000Woo0`00:goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo
1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo
0`006Woo0000\
\>"],
  ImageRangeCache->{{{0, 339}, {103, 0}} -> {-0.551496, -0.700015, 0.0300973, 
  0.0300973}}],

Cell["\<\
Brassard's teleportation \"circuit\" uses the following quantum \
gates:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
L
R
S
T
XOR\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
L, R, S and T are all gates that act on single qubits. L and R \
perform rotations, and S and T perform phase shifts. XOR (for \
\"exclusive-OR\" sometimes called \"controlled-NOT\") acts on 3 qubits \
simultaneously.  We embed these gates in a larger circuit so that we can \
create versions of these quantum operations that act on selected lines in a \
quantum circuit (c.f.  the simulation of Feynman's quantum computer).\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Rotation & Phase-Shift Operators", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Here are the mathematical specifications of the gates.  They are \
all 2 by 2 unitary matrices.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
L = 1/Sqrt[2] {{ 1, -1},
               { 1,  1}};
R = 1/Sqrt[2] {{ 1,  1},
               {-1,  1}};
S = {{I, 0},
     {0, 1}};
T = {{-1, 0},
     {0, -I}};\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Embedding Rotation & Phase-Shift Operators in a Higher Dimensional \
Circuit\
\>", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
(* L that operates on the i-th of m qubits *)
LOP[i_, m_]:=
\tApply[Direct,
\t      ReplacePart[Table[IdentityMatrix[2], {m}], L, i]]

(* R that operates on the i-th of m qubits *)
ROP[i_, m_]:=
\tApply[Direct,
\t      ReplacePart[Table[IdentityMatrix[2], {m}], R, i]]

(* S that operates on the i-th of m qubits *)
SOP[i_, m_]:=
\tApply[Direct,
\t      ReplacePart[Table[IdentityMatrix[2], {m}], S, i]]

(* T that operates on the i-th of m qubits *)
TOP[i_, m_]:=
\tApply[Direct,
\t      ReplacePart[Table[IdentityMatrix[2], {m}], T, i]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(TOP\)\" is similar to \
existing symbol \"\!\(Top\)\"."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["XOR Gate", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
XOR = {{1,0,0,0},
       {0,1,0,0},
       {0,0,0,1},
       {0,0,1,0}};

XORGate[a_, b_, m_]:=
\tCNGate[a, b, m]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(XOR\)\" is similar to \
existing symbol \"\!\(Xor\)\"."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teleportation Circuit", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The teleportation circuit can be pictured as consisting of two \
parts.  One part represents the actions of Alice, the person wishing to \
teleport the unknown state, and the other part represents the actions of Bob, \
the person wishing to receive the teleported state.  In the diagram, the \
dashed boxes circumscribe the domains of responsibility of each party:\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{340, 104},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005D0000J1000`40O003h00OogooEGoo003oOomE
Ool00?mooeEoo`00B7oo0P0000Aoo`00001oo`T00003Ool0000000=oo`<009=oo`D0009oo`80009o
o`<005=oo`00BGoo0`000goo00<007ooOol00Woo00@007ooOol0009oo`03001oo`0009Moo`06001o
ogoo001oo`000Woo00<007oo00000Woo00<007ooOol0D7oo0019Ool00`00Ool00003Ool00`00Oomo
o`02Ool01000Oomoo`000Woo00<007oo00000`00U7oo100000Moo`00Oomoo`00Ool00002Ool00`00
Oomoo`1@Ool004Yoo`8000=oo`04001oogooOol20003Ool30002Ool2002EOol01000Oomoo`000Woo
0P000Woo0`00Dgoo0019Ool20004Ool00`00Oomoo`2QOol50006Ool00`00Oomoo`1COol004ioo`80
00Aoo`03001oogoo0:Ioo`8005Eoo`00ogooEGoo003oOomEOol001Ioo`<000=oo`@0009oo`D0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@002Yoo`@0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@000=oo`@0009oo`D0009oo`@001aoo`005Woo00<007ooOol0Xgoo00<007ooOol0UGoo
000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03
001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yoo`03001oogoo01Qoo`005Woo00<007ooOol0
NWoo00<007ooOol09Woo00<007ooOol0A7oo4@009Goo00<007ooOol067oo002COol00`00Oomoo`1]
Ool00`00Oomoo`0=Ool00`00Oomoo`0SOol00`00Oomoo`0HOol0045oo`H004aoo`03001oogoo031o
o`H003Moo`03001oogoo00eoo`03001oogoo02=oo`03001oogoo01Qoo`005Woo00<007ooOol09goo
00D007ooOomoo`00009oo`8007=oo`03001oogoo00Ioo`05001oogooOol00002Ool2000eOol00`00
Oomoo`0=Ool00`00Oomoo`0nOol001Ioo`03001oogoo02Ioo`03001oogoo009oo`03001oogoo009o
o`03001oogoo071oo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo039o
o`03001oogoo00eoo`03001oogoo03ioo`000Woo00<007ooOol04Goo00<007ooOol09Woo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol09Woo00<007ooOol01Goo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0<Woo00<007ooOol03Goo00<007ooOol08goo00<007oo
Ool01Goo00<007ooOol047oo0002Ool00`00Oomoo`0AOol00`00Oomoo`0UOol00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0VOol00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`0FOol4000GOol00`00Oomoo`0=Ool00`00Oomoo`0EOol4000:Ool0
0`00Oomoo`05Ool01@00Oomoogoo00003Woo0002Ool00`00Oomoo`0iOol00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0]Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`0EOol6000FOol00`00Oomoo`02Ool50006Ool00`00Oomoo`0DOol60009Ool00`00Oomoo`05
Ool01@00Oomoogoo00003Woo0002Ool01000Ool000000Woo0P00<goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol0AWoo00<007ooOol0;7oo00<007ooOol017oo00<007ooOol00goo00<007oo
Ool05Goo1P005Woo00<007ooOol017oo00<007ooOol01Woo00<007ooOol057oo1P002Goo00<007oo
Ool01Goo00<007ooOol00`000Woo0P002Goo0002Ool20002Ool01000Oomoogoo0P001WoolP001Woo
00<007ooOol01Woo:`000goo00L007oo001oo`00Ool00003Ool20007Ool0009oo`80009oo`03001o
ogoo00=oo`03001oogoo00Moo`03001oogoo02Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001o
ogoo06moo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo01Eoo`H001Io
o`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo01Aoo`H0015oo`07001oo`00Ool007oo0000
1Goo00<007ooOol017oo0002Ool20002Ool01000Oomoogoo0P002Woo00<007ooOol097oo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol0Kgoo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol05Woo10005goo00D007ooOomoo`00009oo`04001oogoo0005Ool00`00Oomo
o`0EOol4000BOol01`00Ool007oo001oo`0000=oo`8000Moo`000Woo0P000Woo00@007oo000000ao
o`03001oogoo02Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo04Ioo`03001oogoo00Eo
o`03001oogoo01ioo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo01Qo
o`03001oogoo01Ioo`05001oogooOol00002Ool01000Oomoo`001Goo00<007ooOol05Woo00<007oo
Ool02Woo00<007ooOol01Goo0`0000Eoo`00Ool007oo008000Uoo`000Woo0P000Woo00<007ooOol0
3Goo00<007ooOol09Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol0
1Goo00<007ooOol07Woo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
6Goo00<007ooOol05Woo00@007ooOomoo`L000Eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001o
ogoo00Eoo`05001oogooOol0000>Ool0009oo`04001oo`00000jOol01@00Oomoogoo00000Woo0P00
BWoo00<007ooOol01Goo0`009goo00D007ooOomoo`00009oo`8001aoo`03001oogoo01Ioo`03001o
ogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011oo`000Woo
00<007ooOol0?7oo1P00C7oo00<007ooOol01Goo00@007ooOol002Moo`H001ioo`03001oogoo01Io
o`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011o
o`005Woo00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo01Ioo`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo02Eoo`005Woo
00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001oogoo01io
o`03001oogoo01Iooa4001Qoo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo
00<007ooOol01Woo0P007Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo000FOol00`00Oomoo`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol0
0`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`00A7oo00<007ooOol0C7oo00<0
07ooOol0<goo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014
Ool00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:
Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo07Eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo03moo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo
00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomo
o`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo04aoo`03
001oogoo02Ioo`03001oogoo00Yoo`03001oogoo01ioo`03001oogoo03moo`03001oogoo00Yoo`03
001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo00<007ooOol09Woo00<007ooOol0
2Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014Ool00`00
Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`0HOol004Aoo`03001oogoo04aoo`03001oogoo03=oo`03001oogoo01ioo`03001oogoo03mo
o`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo00<007oo
Ool02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`0[Ool0
0`00Oomoo`1eOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0UOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<0
07ooOol0C7oo00<007ooOol09Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<0
07ooOol02Woo00<007ooOol067oo000JOolB000HOol00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00
Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Yoo`03001oogoo00io
o`03001oogoo01Ioo`03001oogoo01eoo`@002]oo`03001oogoo03=oo`03001oogoo01ioo`03001o
ogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`006Woo00<007ooOol03Woo00<007ooOol05Woo
00<007ooOol06goo0P0000Eoo`00Oomoo`00061oo`03001oogoo01ioo`03001oogoo03moo`03001o
ogoo02Eoo`005Woo00D007ooOomoo`00011oo`03001oogoo01Ioo`03001oogoo01Uoo`8000=oo`05
001oogooOol0001BOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0U
Ool0009oo`03001oogoo015oo`05001oogooOol0000@Ool00`00Oomoo`0FOol00`00Oomoo`0IOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1?Ool00`00Oomoo`0:Ool00`00Oomoo`0NOol0
0`00Oomoo`0oOol00`00Oomoo`0BOol00`00Oomoo`0@Ool0009oo`03001oogoo015oo`05001oogoo
Ool0000@Ool00`00Oomoo`0DOol4000IOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0V
Ool00`00Oomoo`0VOol00`00Oomoo`08Ool4000OOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0AOol01@00Oomoogoo00001Goo1P001Goo
00<007ooOol04goo1P0067oo00<007ooOol00goo00<007ooOol00goo00<007ooOol09Goo00<007oo
Ool09Woo00<007ooOol01goo1P007Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol01Goo
00@007ooOol000moo`000Woo00@007oo0000009oo`80011oo`03001oogoo00Aoo`05001oogooOol0
0005Ool00`00Oomoo`0COol6000GOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0UOol0
0`00Oomoo`06Ool00`00Oomoo`0WOol6000NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool00`00Ool0000200000goo0000000;Ool0009oo`80009oo`04001oogooOol20006Ool90006
Ool01@00Oomoogoo00001GooK@0087ooQP000goo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0P00
0Woo00<007ooOol00goo00<007ooOol01goo00D007ooOomoo`0000Ioo`03001oogoo00Moo`03001o
ogoo01=oo`H001Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo04eoo`03001oogoo00Mo
o`H001ioo`03001oogoo03moo`03001oogoo019oo`800004Ool007oo0004Ool00`00Oomoo`06Ool0
009oo`80009oo`04001oogooOol2000:Ool01@00Oomoogoo00001Woo00<007ooOol01goo00<007oo
Ool057oo10006Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0;Woo00<007ooOol07Goo
00<007ooOol027oo10007goo00<007ooOol0?goo00<007ooOol04Woo0P0000Aoo`00Ool0009oo`80
00Uoo`000Woo0P000Woo00@007oo000000aoo`05001oogooOol00006Ool00`00Oomoo`07Ool00`00
Oomoo`0aOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomoo`07Ool00`00
Oomoo`0LOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00
Ool0000200000goo0000000;Ool0009oo`80009oo`03001oogoo00eoo`05001oogooOol00005Ool4
0007Ool00`00Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomo
o`05Ool00`00Ool0000NOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool01000Oomoo`003goo0002Ool01000Ool0000047oo00D007ooOomoo`00011oo`03001oogoo
039oo`8000=oo`04001oogooOol2000XOol00`00Oomoo`05Ool3000NOol00`00Oomoo`0[Ool00`00
Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0E
Ool00`00Oomoo`0>Ool00`00Oomoo`0UOol3000<Ool7000ZOol00`00Oomoo`1DOol00`00Oomoo`0o
Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool001Yoo`03001oogoo00ioo`03001o
ogoo02Aoo`05001oogooOol0000>Ool00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`04001oogooOolB000VOol01@00Oomoogoo00003Woo
00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0iOol01@00Oomoogoo00003Woo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`0jOol5000=Ool00`00Oomoo`0[Ool00`00Oomoo`0VOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo04ao
o`03001oogoo02]oo`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yo
o`03001oogoo01Qoo`00IGoo00<007ooOol0:goo00<007ooOol0E7oo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo089oo`03001oogoo03moo`03001oogoo
02Eoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00Oomoo`0[Ool00`00Oomoo`0o
Ool00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]oo`03001oogoo02Ioo`03001o
ogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo
00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol02Woo
00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol00`00Oomo
o`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo02]oo`03001oogoo05Aoo`03001oogoo03moo`03
001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0
:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]o
o`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qo
o`005Woo00<007ooOol0C7oo00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007oo
Ool0?goo00<007ooOol02Woo00<007ooOol067oo000FOol00`00Oomoo`1<Ool00`00Oomoo`0FOolA
0004Ool00`00Oomoo`0VOol01000Oomoogoo4P0067oo00<007ooOol05Woo4@0067oo00<007ooOol0
2Woo00<007ooOol067oo001UOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0FOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00
Oomoo`0FOol00`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo01Ioo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo02Yoo`03001oogoo00ioo`03001oogoo01=oo`L001Eoo`03001o
ogoo00eoo`03001oogoo01=oo`L000Uoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007oo
Ool05Woo00<007ooOol03Goo00<007ooOol0:goo00D007ooOomoo`00011oo`03001oogoo015oo`80
00=oo`05001oogooOol0000DOol00`00Oomoo`0=Ool00`00Oomoo`0BOol01@00Oomoogoo00000goo
00<007ooOol08Goo0002Ool00`00Oomoo`0AOol00`00Oomoo`1<Ool00`00Oomoo`0FOol00`00Oomo
o`0=Ool00`00Oomoo`0[Ool01@00Oomoogoo000047oo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol04Goo00<007ooOol03Goo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol047oo0002Ool01@00Oomoogoo00003goo00<007oo
Ool0C7oo00<007ooOol05Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol09Woo00D007oo
Oomoo`00011oo`03001oogoo011oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo015oo`03
001oogoo00eoo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`03
001oogoo00Eoo`04001oogoo000?Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1:Ool4000G
Ool01000Oomoogoo0`000Woo0P001Goo00<007ooOol00Woo00<007ooOol09Woo00D007ooOomoo`00
00Eoo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03
001oogoo009oo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo00<0009oo`8005Ioo`H001Io
o`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`0QOol00`00Oomoo`03Ool01@00Oomoogoo00001Woo00<007ooOol03goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol047oo00<007ooOol00Woo00D007ooOomoo`0000Ioo`03001oogoo011o
o`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00Eoo`03001oo`000080
0003Ool0000000]oo`000Woo00L007oo001oo`00Ool00003Ool20004Oom]0004Ool01000Oomoo`00
1goo2P0087oo2@002Goo00<007ooOol017oo<`0027oo00<007ooOol017oo:`000goo0P0000Aoo`00
Ool0009oo`8000Uoo`000Woo00L007oo001oo`00Ool00005Ool00`00Oomoo`1AOol6000FOol00`00
Oomoo`02Ool40007Ool00`00Oomoo`0_Ool00`00Oomoo`04Ool30007Ool00`00Oomoo`0?Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool30007Ool00`00Oomoo`0@
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool2000017oo001oo`0017oo00<007oo
Ool01Woo0002Ool01`00Ool007oo001oo`0000=oo`8000Qoo`03001oogoo04Uoo`H001Ioo`03001o
ogoo009oo`05001oogooOol00006Ool00`00Oomoo`0;Ool00`00Oomoo`0MOol01@00Oomoogoo0000
1Goo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
47oo00<007ooOol00Woo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol037oo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0`0000Eoo`00Ool007oo0080
00Yoo`03001oogoo04Yoo`@001Moo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`0<
Ool00`00Oomoo`0LOol01@00Oomoogoo00001Goo00D007ooOomoo`0000Ioo`03001oogoo011oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03001oogoo009oo`05001oogooOol00006
Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0<Ool00`00Ool00002
00000goo0000000;Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1UOol01000Oomoogoo1@00
1goo00<007ooOol00Woo00<007ooOol01Goo00<007oo00007Woo00D007ooOomoo`0000Ioo`@000Io
o`03001oogoo015oo`03001oogoo009oo`03001oogoo009oo`03001oogoo015oo`03001oogoo00=o
o`@000Ioo`03001oogoo015oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo015oo`03001oogoo06Eoo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo00Eoo`<001ioo`05001oogooOol0000@Ool00`00Oomoo`0AOol2
0003Ool00`00Oomoo`02000DOol00`00Oomoo`0=Ool00`00Oomoo`0AOol30002Ool01000Oomoogoo
0P001goo00<007ooOol01Goo00@007ooOol000moo`000Woo00<007ooOol0NGoo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0:Woo00<007ooOol03Woo00<007ooOol04goo1P005Woo00<007oo
Ool03Goo00<007ooOol057oo0`0000=oo`0000002Goo00<007ooOol01Goo00<007ooOol047oo001n
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0F
Ool00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`0FOol2000;Ool00`00Oomoo`0HOol007io
o`03001oogoo00eoo`03001oogoo02moo`03001oogoo00ioo`03001oogoo02moo`03001oogoo00eo
o`03001oogoo03ioo`005Woo00<007ooOol0IGoo4@00;Goo00@007ooOomooa80035ooa40041oo`00
5Woo00<007ooOol0Xgoo00<007ooOol0UGoo000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00
Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yo
o`03001oogoo01Qoo`006Goo10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000goo
10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo
10000Woo0`00:goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo
1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo
0`006Woo0000\
\>"],
  ImageRangeCache->{{{0, 339}, {103, 0}} -> {-0.551496, -0.700015, 0.0300973, 
  0.0300973}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teleporting an Unknown State from Alice to Bob", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Step 1: Preparation (Alice's job)", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
For Alice to teleport an arbitrary, unknown, quantum state to Bob, \
she begins by creating a pair of particles whose quantum states are highly \
correlated with one another.  Alice keeps one of these particles and sends \
the other to Bob (via the bottom line of the teleportation \"circuit\").  \
Although the two particles become physically remote from one another, the \
correlation between their states persists so long as neither particle is \
measured nor interacts with its environment in any way.  Such correlated \
particles are referred to as \"ebits\" in the jargon of quantum computing.

To create the ebits, Alice pushes two standard states (two particles each in \
state |0>) through the following circuit.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["AliceCreatesEbit[];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .625 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.126437 0.410509 0.0969828 0.410509 [
[ 0 0 0 0 ]
[ 1 .625 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .625 L
0 .625 L
closepath
clip
newpath
p
p
1 Mabswid
.22906 .40486 m
.22906 .61012 L
.43432 .61012 L
.43432 .40486 L
.22906 .40486 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .33169 .50749 0 0 Mshowa
P
.12644 .50749 m
.22906 .50749 L
s
.43432 .50749 m
.53695 .50749 L
s
newpath
.7422 .09698 .0821 0 365.73 arc
s
6 Mabswid
.7422 .50749 Mdot
1 Mabswid
.7422 .01488 m
.7422 .50749 L
s
.53695 .09698 m
.94745 .09698 L
s
.53695 .50749 m
.94745 .50749 L
s
.12644 .09698 m
.53695 .09698 L
s
P
p
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .09698 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .50749 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(s)] .97619 .50749 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(r)] .97619 .09698 -1 0 Mshowa
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{183, 113},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002g0000LA000`40O003h00O]goo002gOol00;Mo
o`00Pgoo1`00;Goo0020Ool30003Ool01000Oomoogoo0`00:Woo001nOol20006Ool00`00Oomoo`04
Ool2000XOol007eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo02Eoo`00O7oo00<007oo
Ool01goo00<007ooOol01goo00<007ooOol097oo001kOol00`00Oomoo`08Ool00`00Oomoo`08Ool0
0`00Oomoo`0SOol007Yoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo02=oo`00NWoo00<0
07ooOol02Goo00<007ooOol02Goo00<007ooOol08Woo001iOol00`00Oomoo`0:Ool00`00Oomoo`0:
Ool00`00Oomoo`0QOol007Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo025oo`00N7oo
00<007ooOol02goo00<007ooOol02goo00<007ooOol087oo0006Ool00`00Oomoo`1_Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0JOol00`00Oomoo`03Ool000Ioo`03001oogoo06moo`03
001oogoo00]oo`03001oogoo00]oo`03001oogoo01Yoo`03001oogoo00=oo`001Woo00<007ooOol0
KWoo00<007ooOol037oo00<007ooOol037oo00<007ooOol06Goo00<007ooOol00goo0006Ool00`00
Oomoo`03Ool30005Ool00`00Oomoo`1POol00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0I
Ool40002Ool000Ioo`03001oogoo009oo`05001oogooOol00005Ool200000goo0000002B0005Ool0
1@00Oomoogoo00000Goo0006Ool00`00Oomoo`02Ool01@00Oomoogoo00001goo0P00GWoo00<007oo
Ool037oo00<007ooOol037oo00<007ooOol06Goo00D007ooOomoo`00005oo`001Woo00<007ooOol0
0Woo00D007ooOomoo`0000Eoo`80061oo`03001oogoo00aoo`03001oogoo00]oo`03001oogoo01Yo
o`05001oogooOol00001Ool000Ioo`03001oogoo009oo`05001oogooOol00004Ool00`00Oomoo`1P
Ool00`00Oomoo`0<Ool00`00Oomoo`0;Ool00`00Oomoo`0KOol30002Ool000Ioo`03001oogoo009o
o`05001oogooOol0001XOol00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0POol000Ioo`03
001oogoo009oo`80009oo`03001oogoo06Ioo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo
025oo`001Woo00<007ooOol00goo0`00JGoo00<007ooOol02goo00<007ooOol02Woo00<007ooOol0
8Goo0006Ool00`00Oomoo`1`Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`0QOol000Io
o`03001oogoo071oo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo029oo`00NWoo00<007oo
Ool02Goo00<007ooOol027oo00<007ooOol08goo001kOol00`00Oomoo`08Ool00`00Oomoo`07Ool0
0`00Oomoo`0TOol007aoo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo02Eoo`00OGoo0`00
1Woo00<007ooOol017oo0P00:7oo0020Ool30003Ool00`00Oomoo`03Ool00`00Oomoo`0XOol008=o
o`T002]oo`00QWoo00<007ooOol0;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00
QWoo00<007ooOol0;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00QWoo00<007oo
Ool0;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00QWoo00<007ooOol0;Woo0026
Ool00`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00QWoo00<007ooOol0;Woo0026Ool00`00Oomo
o`0^Ool008Ioo`03001oogoo02ioo`00QWoo00<007ooOol0;Woo0026Ool00`00Oomoo`0^Ool008Io
o`03001oogoo02ioo`00QWoo00<007ooOol0;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03001oogoo
02ioo`00QWoo00<007ooOol0;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00QWoo
00<007ooOol0;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00QWoo00<007ooOol0
;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00QWoo00<007ooOol0;Woo0026Ool0
0`00Oomoo`0^Ool008Ioo`03001oogoo02ioo`00QWoo00<007ooOol0;Woo0026Ool00`00Oomoo`0^
Ool008Ioo`03001oogoo02ioo`00QWoo00<007ooOol0;Woo0026Ool00`00Oomoo`0^Ool008Ioo`03
001oogoo02ioo`00QWoo00<007ooOol0;Woo000ZOolV000fOol00`00Oomoo`0^Ool002Yoo`03001o
ogoo029oo`03001oogoo03Aoo`03001oogoo02ioo`00:Woo00<007ooOol08Woo00<007ooOol0=7oo
00<007ooOol0;Woo000ZOol00`00Oomoo`0ROol00`00Oomoo`0dOol00`00Oomoo`0^Ool002Yoo`03
001oogoo029oo`03001oogoo03Aoo`03001oogoo02ioo`00:Woo00<007ooOol08Woo00<007ooOol0
=7oo00<007ooOol0;Woo000ZOol00`00Oomoo`0ROol00`00Oomoo`0dOol00`00Oomoo`0^Ool002Yo
o`03001oogoo029oo`03001oogoo03Aoo`03001oogoo02ioo`00:Woo00<007ooOol08Woo00<007oo
Ool0=7oo00<007ooOol0;Woo000ZOol00`00Oomoo`0ROol00`00Oomoo`0dOol00`00Oomoo`0^Ool0
02Yoo`03001oogoo029oo`03001oogoo03Aoo`03001oogoo02ioo`00:Woo00<007ooOol08Woo00<0
07ooOol0=7oo00<007ooOol0;Woo000ZOol00`00Oomoo`0ROol00`00Oomoo`0dOol00`00Oomoo`0^
Ool002Yoo`03001oogoo029oo`03001oogoo03Aoo`03001oogoo02ioo`001Woo00<007ooOol08Goo
00<007ooOol08Woo00<007ooOol0=7oo00<007ooOol0;Woo0006Ool00`00Oomoo`0QOol00`00Oomo
o`0ROol00`00Oomoo`0dOol00`00Oomoo`0^Ool000Ioo`03001oogoo025oo`03001oogoo00eoo`H0
00moo`03001oogoo039oo`@002moo`001Woo00<007ooOol00goo0`001Goo00<007ooOol04goo00<0
07ooOol03Woo00D007ooOomoo`0000moo`03001oogoo035oo`H002Qoo`@0009oo`001Woo00<007oo
Ool00Woo00D007ooOomoo`0000Eoo`800003Ool000000140011oo`05001oogooOol0000?OomM0004
Ool20003Ool10001Ool000Ioo`03001oogoo009oo`05001oogooOol00007Ool2000AOol00`00Oomo
o`0>Ool00`00Oomoo`0AOol00`00Oomoo`0aOol6000WOol00`00Oomoo`02Ool10001Ool000Ioo`03
001oogoo009oo`05001oogooOol00005Ool2000COol00`00Oomoo`0>Ool00`00Oomoo`0AOol00`00
Oomoo`0aOol6000WOol01000Oomoogoo0P000Goo0006Ool00`00Oomoo`02Ool01@00Oomoogoo0000
17oo00<007ooOol04goo00<007ooOol03Woo00<007ooOol04Goo00<007ooOol0<Woo1000:Goo1P00
0006Ool00`00Oomoo`02Ool01@00Oomoogoo00006Woo00<007ooOol03Goo10004Goo00<007ooOol0
IGoo0006Ool00`00Oomoo`02Ool20002Ool00`00Oomoo`0HOol00`00Oomoo`0ROol00`00Oomoo`1U
Ool000Ioo`03001oogoo00=oo`<001]oo`03001oogoo029oo`03001oogoo06Eoo`001Woo00<007oo
Ool08Goo00<007ooOol08Woo00<007ooOol0IGoo0006Ool00`00Oomoo`0QOol00`00Oomoo`0ROol0
0`00Oomoo`1UOol002Yoo`03001oogoo029oo`03001oogoo06Eoo`00:Woo00<007ooOol08Woo00<0
07ooOol0IGoo000ZOol00`00Oomoo`0ROol00`00Oomoo`1UOol002Yoo`03001oogoo029oo`03001o
ogoo06Eoo`00:Woo00<007ooOol08Woo00<007ooOol0IGoo000ZOol00`00Oomoo`0ROol00`00Oomo
o`1UOol002Yoo`03001oogoo029oo`03001oogoo06Eoo`00:Woo00<007ooOol08Woo00<007ooOol0
IGoo000ZOol00`00Oomoo`0ROol00`00Oomoo`1UOol002Yoo`03001oogoo029oo`03001oogoo06Eo
o`00:Woo9P00Igoo002gOol00;Moo`00\
\>"],
  ImageRangeCache->{{{0, 182}, {112, 0}} -> {-0.327044, -0.236258, 0.0135939, 
  0.0135939}}]
}, Open  ]],

Cell["\<\

The outputs are labelled by sigma and rho rather than individual ket vectors \
because the states on each output line are not pure states.  Instead, the \
output states are entangled with one another.  To see this, look at the \
action of this circuit algebraically:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The circuit consists of an L gate and an XOR gate. There are two \
lines in the circuit. We can number the top line as \"line 1\" and the bottom \
line as \"line 2\". Thus the circuit can be described as the dot product of \
the matrices representing the action of each gate. LOP[i,m] is an L gate that \
acts on the i-th of m qubits. XORGate[i,j,m] is an XOR gate that acts on the \
i-th and j-th of m qubits.  So the overall operation of the circuit is \
described by XORGate[1,2,2] . LOP[1,2].

The circuit has two inputs, represented by two kets (which will actually both \
be set to the standard state |0>).  So the overall action of the circuit on \
an arbitrary pair of states is defined by the command Step1:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Step1[ket1_, ket2_]:=
\t(XORGate[1,2,2] . 
\t LOP[1,2] . 
\t KetToColumnVector[Direct[ket1, ket2]]) // ColumnVectorToKet\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
To see what this circuit does to the state input state |00>, try \
the following.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Step1[ket[0], ket[0]]
\t\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(ket[0, 0]\/\@2 + ket[1, 1]\/\@2\)], "Output"]
}, Open  ]],

Cell["\<\
Notice that the resulting state is entangled: if you measured one \
of the outputs and obtained the answer \"0\", then a subsequent measurement \
on the other output would also yield the answer \"0\". Likewise, if you \
measured one of the outputs and obtained the answer \"1\", a subsequent \
measurement on the other output would also yield a \"1\".  Hence, although \
each output is in a superposition of 0 and 1, the joint state of the outputs \
are strongly correlated, or \"entangled\", with one another.   By retaining \
one of these output states and sending the other to Bob, Alice establishes a \
quantum communication channel between herself and Bob via the enduring \
correlation between the ebits labelled sigma and rho.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Step 2: Entanglement (also Alice's job)", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Next, suppose Alice wants to teleport a particular quantum state to \
Bob. Alice need not know what this state is in order to teleport it \
successfully, so without loss of generality we can say that the state is \
\"unknown\".  To teleport the state, Alice entangles it with one of the ebits \
she created in Step 1. Again the entangling is done by pushing certain states \
through a particular quantum circuit.  In this case the circuit  is shown \
below:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["AliceEntanglesEbitWithUnknownState[]", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .57647 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0798319 0.22409 0.0585434 0.22409 [
[ 0 0 0 0 ]
[ 1 .57647 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .57647 L
0 .57647 L
closepath
clip
newpath
p
p
1 Mabswid
.13585 .22661 m
.13585 .33866 L
.2479 .33866 L
.2479 .22661 L
.13585 .22661 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .19188 .28263 0 0 Mshowa
P
.07983 .28263 m
.13585 .28263 L
s
.2479 .28263 m
.30392 .28263 L
s
newpath
.41597 .05854 .04482 0 365.73 arc
s
6 Mabswid
.41597 .28263 Mdot
1 Mabswid
.41597 .01373 m
.41597 .28263 L
s
.30392 .05854 m
.52801 .05854 L
s
.30392 .28263 m
.52801 .28263 L
s
.07983 .05854 m
.30392 .05854 L
s
P
p
1 Mabswid
newpath
.64006 .28263 .04482 0 365.73 arc
s
6 Mabswid
.64006 .50672 Mdot
1 Mabswid
.64006 .23782 m
.64006 .50672 L
s
.52801 .28263 m
.7521 .28263 L
s
.52801 .50672 m
.7521 .50672 L
s
.80812 .4507 m
.80812 .56275 L
.92017 .56275 L
.92017 .4507 L
.80812 .4507 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .86415 .50672 0 0 Mshowa
P
.7521 .50672 m
.80812 .50672 L
s
.92017 .50672 m
.97619 .50672 L
s
.7521 .28263 m
.97619 .28263 L
s
P
p
p
/Symbol findfont 12 scalefont setfont
[(| y >)] .02381 .50672 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .05854 -1 0 Mshowa
P
p
/Symbol findfont 12 scalefont setfont
[(| 0 >)] .02381 .28263 -1 0 Mshowa
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 162},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000XQ000`40O003h00Oogoo6goo003oOolK
Ool00?mooa]oo`00ogoo6goo001bOol6002ROol0071oo`8000=oo`03001oogoo00800:1oo`00KGoo
0`001Goo00<007ooOol00Woo0P00WWoo001/Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomo
o`2KOol006aoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo09Yoo`00Jgoo00<007ooOol0
1goo00<007ooOol01Woo00<007ooOol0VGoo001ZOol00`00Oomoo`08Ool00`00Oomoo`07Ool00`00
Oomoo`2HOol006Uoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo09Moo`00JGoo00<007oo
Ool02Goo00<007ooOol027oo00<007ooOol0Ugoo0008Ool00`00Oomoo`1MOol00`00Oomoo`0:Ool0
0`00Oomoo`08Ool00`00Oomoo`2GOol000Qoo`03001oogoo05eoo`03001oogoo00Yoo`03001oogoo
00Qoo`03001oogoo09Moo`0027oo00<007ooOol0GGoo00<007ooOol02Woo00<007ooOol02Goo00<0
07ooOol0UWoo0008Ool00`00Oomoo`03Ool30005Ool00`00Oomoo`1?Ool00`00Oomoo`0:Ool00`00
Oomoo`09Ool00`00Oomoo`2FOol000Qoo`03001oogoo009oo`05001oogooOol00005Oomn0025Ool0
00Qoo`03001oogoo009oo`05001oogooOol00007Ool2001=Ool00`00Oomoo`0:Ool00`00Oomoo`09
Ool00`00Oomoo`2FOol000Qoo`03001oogoo009oo`05001oogooOol00005Ool2001?Ool00`00Oomo
o`0:Ool00`00Oomoo`09Ool00`00Oomoo`2FOol000Qoo`03001oogoo009oo`05001oogooOol00004
Ool00`00Oomoo`1?Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`2FOol000Qoo`03001o
ogoo009oo`05001oogooOol0001GOol00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`2GOol0
00Qoo`03001oogoo009oo`80009oo`03001oogoo05Eoo`03001oogoo00Uoo`03001oogoo00Qoo`03
001oogoo09Moo`0027oo00<007ooOol00goo0`00FGoo00<007ooOol027oo00<007ooOol027oo00<0
07ooOol0Ugoo0008Ool00`00Oomoo`1OOol00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`2H
Ool000Qoo`03001oogoo061oo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo09Uoo`00K7oo
00<007ooOol01Woo00<007ooOol017oo0P00W7oo001]Ool20006Ool00`00Oomoo`03Ool00`00Oomo
o`2LOol006moo`<000=oo`03001oogoo009oo`03001oogoo09eoo`00LWoo2000X7oo001eOol00`00
Oomoo`2ROol007Eoo`03001oogoo0:9oo`00MGoo00<007ooOol0XWoo001eOol00`00Oomoo`2ROol0
07Eoo`03001oogoo0:9oo`00MGoo00<007ooOol0XWoo001eOol00`00Oomoo`2ROol007Eoo`03001o
ogoo0:9oo`00MGoo00<007ooOol0XWoo001eOol00`00Oomoo`2ROol007Eoo`03001oogoo0:9oo`00
MGoo00<007ooOol0XWoo001eOol00`00Oomoo`2ROol007Eoo`03001oogoo0:9oo`00MGoo00<007oo
Ool0XWoo001eOol00`00Oomoo`2ROol007Eoo`03001oogoo0:9oo`00MGoo00<007ooOol0XWoo001e
Ool00`00Oomoo`2ROol007Eoo`03001oogoo0:9oo`00MGoo00<007ooOol0XWoo001eOol00`00Oomo
o`2ROol007Eoo`03001oogoo0:9oo`00MGoo00<007ooOol0XWoo001eOol00`00Oomoo`2ROol007Eo
o`03001oogoo0:9oo`00MGoo00<007ooOol0XWoo001eOol00`00Oomoo`2ROol007Eoo`03001oogoo
0:9oo`00MGoo00<007ooOol0XWoo001eOol00`00Oomoo`2ROol007Eoo`03001oogoo0:9oo`00MGoo
00<007ooOol0XWoo001eOol00`00Oomoo`2ROol002Ioob4002ioo`03001oogoo0:9oo`009Woo00<0
07ooOol07Goo00<007ooOol0;7oo00<007ooOol0XWoo000VOol00`00Oomoo`0MOol00`00Oomoo`0/
Ool00`00Oomoo`2ROol002Ioo`03001oogoo01eoo`03001oogoo02aoo`03001oogoo03Uoo`P0065o
o`009Woo00<007ooOol07Goo00<007ooOol0;7oo00<007ooOol0=Woo0`000Woo00<007ooOol00goo
00<007ooOol0GWoo000VOol00`00Oomoo`0MOol00`00Oomoo`0/Ool00`00Oomoo`0dOol20005Ool0
0`00Oomoo`04Ool00`00Oomoo`1MOol002Ioo`03001oogoo01eoo`03001oogoo02aoo`03001oogoo
03=oo`03001oogoo00Eoo`03001oogoo00Eoo`8005eoo`009Woo00<007ooOol07Goo00<007ooOol0
;7oo00<007ooOol0<Woo00<007ooOol01Woo00<007ooOol01goo00<007ooOol0FWoo000VOol00`00
Oomoo`0MOol00`00Oomoo`0/Ool00`00Oomoo`0aOol00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`1JOol002Ioo`03001oogoo01eoo`03001oogoo02aoo`03001oogoo035oo`03001oogoo00Mo
o`03001oogoo00Qoo`03001oogoo05Uoo`009Woo00<007ooOol07Goo00<007ooOol0;7oo00<007oo
Ool0<7oo00<007ooOol027oo00<007ooOol027oo00<007ooOol0FGoo0008Ool00`00Oomoo`0KOol0
0`00Oomoo`0MOol00`00Oomoo`0/Ool00`00Oomoo`0`Ool00`00Oomoo`08Ool00`00Oomoo`09Ool0
0`00Oomoo`1HOol000Qoo`03001oogoo01]oo`03001oogoo01eoo`03001oogoo02aoo`03001oogoo
02moo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo05Qoo`0027oo00<007ooOol06goo00<0
07ooOol02Woo1P003Goo00<007ooOol0:Woo1000<7oo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol0F7oo0008Ool00`00Oomoo`03Ool30005Ool00`00Oomoo`0=Ool00`00Oomoo`0;Ool01@00
Oomoogoo00003Goo00<007ooOol0:Goo1P00;goo00<007ooOol02Goo00<007ooOol02Woo00<007oo
Ool0Egoo0008Ool00`00Oomoo`02Ool01@00Oomoogoo00001Goo40003Goo00D007ooOomoo`0000eo
ol`000Qoo`0027oo00<007ooOol00Woo00D007ooOomoo`0000Moo`8000]oo`03001oogoo00]oo`03
001oogoo00moo`03001oogoo02Uoo`H002moo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo
05Moo`0027oo00<007ooOol00Woo00D007ooOomoo`0000Eoo`8000eoo`03001oogoo00]oo`03001o
ogoo00moo`03001oogoo02Uoo`H002moo`03001oogoo00Uoo`03001oogoo00Uoo`8005Uoo`0027oo
00<007ooOol00Woo00D007ooOomoo`0000Aoo`03001oogoo00eoo`03001oogoo00]oo`03001oogoo
00moo`03001oogoo02Yoo`@0031oo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo05Qoo`00
27oo00<007ooOol00Woo00D007ooOomoo`0001Aoo`03001oogoo00Yoo`@000moo`03001oogoo05io
o`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo05Qoo`0027oo00<007ooOol00Woo0P000Woo
00<007ooOol04Woo00<007ooOol07Goo00<007ooOol0GWoo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol0F7oo0008Ool00`00Oomoo`03Ool3000EOol00`00Oomoo`0MOol00`00Oomoo`1NOol0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`1IOol000Qoo`03001oogoo01]oo`03001oogoo
01eoo`03001oogoo05moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo05Yoo`0027oo00<0
07ooOol06goo00<007ooOol07Goo00<007ooOol0H7oo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol0FWoo000VOol00`00Oomoo`0MOol00`00Oomoo`1QOol00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`1KOol002Ioo`03001oogoo01eoo`03001oogoo069oo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo05aoo`009Woo00<007ooOol07Goo00<007ooOol0Hgoo0P001Goo00<007oo
Ool00goo0P00Ggoo000VOol00`00Oomoo`0MOol00`00Oomoo`1UOol20003Ool01000Oomoogoo0P00
HGoo000VOol00`00Oomoo`0MOol00`00Oomoo`1WOol7001SOol002Ioo`03001oogoo01eoo`03001o
ogoo06Yoo`03001oogoo06Aoo`009Woo00<007ooOol07Goo00<007ooOol0JWoo00<007ooOol0I7oo
000VOolQ001/Ool00`00Oomoo`1TOol00;=oo`03001oogoo06Aoo`00/goo00<007ooOol0I7oo002c
Ool00`00Oomoo`1TOol00;=oo`03001oogoo06Aoo`00/goo00<007ooOol0I7oo002cOol00`00Oomo
o`1TOol00;=oo`03001oogoo06Aoo`00/goo00<007ooOol0I7oo002cOol00`00Oomoo`1TOol00;=o
o`03001oogoo06Aoo`00/goo00<007ooOol0I7oo002cOol00`00Oomoo`1TOol00;=oo`03001oogoo
06Aoo`00/goo00<007ooOol0I7oo002cOol00`00Oomoo`1TOol00;=oo`03001oogoo06Aoo`00/goo
00<007ooOol0I7oo002cOol00`00Oomoo`1TOol00;=oo`03001oogoo06Aoo`00/goo00<007ooOol0
I7oo002cOol00`00Oomoo`1TOol00;=oo`03001oogoo06Aoo`00/goo00<007ooOol0I7oo002cOol0
0`00Oomoo`1TOol00;=oo`03001oogoo06Aoo`00/goo00<007ooOol0I7oo002cOol00`00Oomoo`1T
Ool00;=oo`03001oogoo06Aoo`00/goo00<007ooOol0I7oo002cOol00`00Oomoo`1TOol00;=oo`03
001oogoo02aoob0001Qoo`00/goo00<007ooOol0;7oo00<007ooOol077oo00<007ooOol05Woo002c
Ool00`00Oomoo`0/Ool00`00Oomoo`0LOol00`00Oomoo`0FOol00;=oo`03001oogoo02aoo`03001o
ogoo01aoo`03001oogoo01Ioo`00/goo00<007ooOol0;7oo00<007ooOol077oo00<007ooOol05Woo
002cOol00`00Oomoo`0/Ool00`00Oomoo`0LOol00`00Oomoo`0FOol00;=oo`03001oogoo02aoo`03
001oogoo01aoo`03001oogoo01Ioo`00/goo00<007ooOol0;7oo00<007ooOol077oo00<007ooOol0
5Woo002cOol00`00Oomoo`0/Ool00`00Oomoo`0LOol00`00Oomoo`0FOol00;=oo`03001oogoo02ao
o`03001oogoo01aoo`03001oogoo01Ioo`00/goo00<007ooOol0;7oo00<007ooOol077oo00<007oo
Ool05Woo002cOol00`00Oomoo`0/Ool00`00Oomoo`0LOol00`00Oomoo`0FOol000Qoo`03001oogoo
00Eoo`03001oogoo0:1oo`03001oogoo02aoo`03001oogoo01aoo`03001oogoo01Ioo`0027oo00<0
07ooOol01Goo00<007ooOol0X7oo00<007ooOol0;7oo00<007ooOol077oo00<007ooOol05Woo0008
Ool00`00Oomoo`05Ool00`00Oomoo`2OOol4000/Ool00`00Oomoo`09Ool30002Ool2000<Ool00`00
Oomoo`0FOol000Qoo`03001oogoo00=oo`@000Moo`03001oogoo09Eoo`H002]oo`03001oogoo00Yo
o`05001oogooOol0000=Ool00`00Oomoo`0FOol000Qoo`03001oogoo009oo`05001oogoo001oo`02
0006Ool2001hOom?000<Ool01000Oomoo`003Woo4@0027oo0008Ool00`00Oomoo`02Ool01000Oomo
o`000Woo00<007ooOol01Woo0P00Tgoo1P00:goo00<007ooOol02Woo10003Woo00<007ooOol05Woo
0008Ool00`00Oomoo`02Ool01000Oomoo`000Woo00<007ooOol017oo0P00UGoo1P00:goo00<007oo
Ool02Woo00D007ooOomoo`0000eoo`03001oogoo01Ioo`0027oo00@007ooOomoo`80009oo`04001o
ogoo0005Ool00`00Oomoo`2FOol4000/Ool00`00Oomoo`0:Ool01@00Oomoogoo00003Goo00<007oo
Ool05Woo0008Ool00`00Oomoo`05Ool00`00Oomoo`3?Ool00`00Oomoo`09Ool5000>Ool00`00Oomo
o`0FOol000Qoo`03001oogoo0=Moo`03001oogoo01aoo`03001oogoo01Ioo`0027oo00<007ooOol0
egoo00<007ooOol077oo00<007ooOol05Woo0008Ool00`00Oomoo`3GOol00`00Oomoo`0LOol00`00
Oomoo`0FOol000Qoo`03001oogoo0=Moo`03001oogoo01aoo`03001oogoo01Ioo`00hWoo00<007oo
Ool077oo00<007ooOol05Woo003ROol00`00Oomoo`0LOol00`00Oomoo`0FOol00>9oo`03001oogoo
01aoo`03001oogoo01Ioo`00hWoo00<007ooOol077oo00<007ooOol05Woo003ROol00`00Oomoo`0L
Ool00`00Oomoo`0FOol00>9oo`03001oogoo01aoo`03001oogoo01Ioo`00hWoo00<007ooOol077oo
00<007ooOol05Woo003ROolP000HOol00?mooa]oo`00ogoo6goo003oOolKOol00001\
\>"],
  ImageRangeCache->{{{0, 281}, {161, 0}} -> {-0.369965, -0.261262, 0.0159784, 
  0.0159784}}],

Cell[OutputFormData["\<\
Graphics[\"<<>>\"]\
\>", 
"\<\
-Graphics-\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
The correct quantum mechanical description of this circuit now \
involves three inputs and three outputs. Algebraically the state \
transformation is given by:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Step2[ket1_, ket2_, ket3_]:=
\t(ROP[1,3] .
\t XORGate[1,2,3] .
\t XORGate[2,3,3] .
\t LOP[2,3] . KetToColumnVector[Direct[ket1, ket2, ket3]]) // \
ColumnVectorToKet\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Let's invent a random arbitrary state, a |0> + b |1>, and see what \
this circuit does to this state:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Step2[a ket[0] + b ket[1], ket[0], ket[0] ]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\/2\ a\ ket[0, 0, 0] + 1\/2\ b\ ket[0, 0, 1] + 1\/2\ b\ ket[0, 1, 0] + 
      1\/2\ a\ ket[0, 1, 1] - 1\/2\ a\ ket[1, 0, 0] + 1\/2\ b\ ket[1, 0, 1] + 
      1\/2\ b\ ket[1, 1, 0] - 1\/2\ a\ ket[1, 1, 1]\)], "Output"]
}, Open  ]],

Cell["\<\
We can also examine the action of Alice's circuit on a specific \
state such as:
           .5 |0> + Sqrt[1-.5^2] |1>  
i.e. if you were to measure this state in the 0/1 basis, you would have a 25% \
chance of obtaining a 0 and a 75% chance of obtaining a 1.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["unknownState = .5 ket[0] + Sqrt[1-.5^2] ket[1]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["0.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->1], " ", \(ket[0]\)}], "+", 
      \(0.866025403784438552`\ ket[1]\)}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Here is the action of Alice on this state:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
state2 = Step2[.5 ket[0] + Sqrt[1-.5^2] ket[1], ket[0], ket[0] \
]\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.25`\ ket[0, 0, 0] + 0.433012701892219276`\ ket[0, 0, 1] + 
      0.433012701892219276`\ ket[0, 1, 0] + 0.25`\ ket[0, 1, 1] - 
      0.25`\ ket[1, 0, 0] + 0.433012701892219276`\ ket[1, 0, 1] + 
      0.433012701892219276`\ ket[1, 1, 0] - 0.25`\ ket[1, 1, 1]\)], "Output"]
}, Open  ]],

Cell["\<\
This represents the joint state of the 3 qubits after Alice has \
pushed the 3 inputs through her circuit.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Step 3: Measurement (Alice's last job)", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Next Alice measures the bits on lines 1 and 2 (the top and middle \
line). To simulate this, we use the command ReadPartOfMemoryRegister that was \
introduced in the simulator for Feynman's quantum computer.  Here is a \
reminder of how to use this command:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?ReadPartOfMemoryRegister", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("ReadPartOfMemoryRegister[superposition, bitsToRead] reads the state  \
of selected bits in the memory register. As the i-th and j-th bit  \
measurement operators commute (for any i and j), it does not matter  in what \
order you measure the bits."\)], "Print"]
}, Open  ]],

Cell["\<\
You may recall that the output from ReadPartOfMemoryRegister \
consists of a two element list: the first element is a record of the answers \
obtained for each bit measured and the second element is the state the memory \
register is left in after all the measurements have been made.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Step3[state_]:=
\tReadPartOfMemoryRegister[state, {1,2}]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["answer3 = ReadPartOfMemoryRegister[state2, {1,2}]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 1}, 0.866025403784438552`\ ket[1, 1, 0] - 0.5`\ ket[1, 1, 1]}\)], 
  "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["This output labelled answer3 means Alice read a ...", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["line1Bit = answer3[[1,1]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell["... for line 1 (the top line) and a ... ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["line2Bit = answer3[[1,2]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell["\<\
... for line 2 (the middle line) at the center of the circuit.  The \
joint state of the three qubits at the mid-point of the circuit after both of \
these measurements have been made is ...\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["state3 = answer3[[2]]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.866025403784438552`\ ket[1, 1, 0] - 0.5`\ ket[1, 1, 1]\)], "Output"]
}, Open  ]],

Cell["\<\
Notice that Alice did not attempt to read the state of the particle \
on the third line. In fact, this corresponds to the ebit already in Bob's \
possession. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me! (an aside...)", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Note that, if you measure identically prepared quantum circuits, \
which are all initialized with identical inputs,  you can obtain different \
answers for the measurements in each case. To see this try re-running the \
last command a few times.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell[CellGroupData[{

Cell["\<\
Table[ReadPartOfMemoryRegister[state2,{1,2}], {5}] // \
ColumnForm\
\>", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \({{1, 0}, 
              \(-0.5`\)\ ket[1, 0, 0] + 0.866025403784438552`\ ket[1, 0, 1]}
              \)},
          {
            \({{1, 1}, 
              0.866025403784438552`\ ket[1, 1, 0] - 0.5`\ ket[1, 1, 1]}\)},
          {
            \({{1, 0}, 
              \(-0.5`\)\ ket[1, 0, 0] + 0.866025403784438552`\ ket[1, 0, 1]}
              \)},
          {
            \({{0, 0}, 
              0.5`\ ket[0, 0, 0] + 0.866025403784438552`\ ket[0, 0, 1]}\)},
          {
            \({{1, 0}, 
              \(-0.5`\)\ ket[1, 0, 0] + 0.866025403784438552`\ ket[1, 0, 1]}
              \)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{{1, 0}, 
        Plus[ 
          Times[ -0.5, 
            ket[ 1, 0, 0]], 
          Times[ 0.86602540378443849, 
            ket[ 1, 0, 1]]]}, {{1, 1}, 
        Plus[ 
          Times[ 0.86602540378443849, 
            ket[ 1, 1, 0]], 
          Times[ -0.5, 
            ket[ 1, 1, 1]]]}, {{1, 0}, 
        Plus[ 
          Times[ -0.5, 
            ket[ 1, 0, 0]], 
          Times[ 0.86602540378443849, 
            ket[ 1, 0, 1]]]}, {{0, 0}, 
        Plus[ 
          Times[ 0.5, 
            ket[ 0, 0, 0]], 
          Times[ 0.86602540378443849, 
            ket[ 0, 0, 1]]]}, {{1, 0}, 
        Plus[ 
          Times[ -0.5, 
            ket[ 1, 0, 0]], 
          Times[ 0.86602540378443849, 
            ket[ 1, 0, 1]]]}}],
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Such repeated measurements are not necessary for quantum \
teleportation. This exercise merely illustrates that the outcomes of \
measurements on quantum systems in superposed states is not \
deterministic.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontTracking->"Plain",
  FontVariations->{"Underline"->False,
  "Outline"->False,
  "Shadow"->False}],

Cell["\<\
Back to business ... Alice's final task is simply to send the \
results of her measurements to Bob via a classical communication channel such \
as sound waves, radio, telephone, or written letter. In the present example, \
Alice would tell Bob she obtained the value stored in the variable \"line1Bit\
\" for line 1 and the value stored in the variable \"line2Bit\" for line 2 of \
the circuit at the mid-point.  After these measurements, the state of the \
circuit at the mid-point is given by the value of the variable state3. In the \
present example, Alice obtained the results:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["line1Bit", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["line2Bit", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["state3", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.866025403784438552`\ ket[1, 1, 0] - 0.5`\ ket[1, 1, 1]\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Step 4 (Bob's job)", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Bob receive's Alice's 2-bit classical message and immediately \
converts those bits to corresponding kets for input into the quantum circuit \
shown below. That is if Alice tells Bob she read a 1 on line 1, Bob creates \
the state |1> for input on line 1 of the following circuit:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["BobCircuit[];", "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .625 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
-1.16667 0.238095 0.0744048 0.238095 [
[ 0 0 0 0 ]
[ 1 .625 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .625 L
0 .625 L
closepath
clip
newpath
p
1 Mabswid
newpath
.14286 .0744 .04762 0 365.73 arc
s
6 Mabswid
.14286 .3125 Mdot
1 Mabswid
.14286 .02679 m
.14286 .3125 L
s
.02381 .0744 m
.2619 .0744 L
s
.02381 .3125 m
.2619 .3125 L
s
.08333 .49107 m
.08333 .61012 L
.20238 .61012 L
.20238 .49107 L
.08333 .49107 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .14286 .5506 0 0 Mshowa
P
.02381 .5506 m
.08333 .5506 L
s
.20238 .5506 m
.2619 .5506 L
s
newpath
.38095 .5506 .04762 0 365.73 arc
s
6 Mabswid
.38095 .0744 Mdot
1 Mabswid
.38095 .59821 m
.38095 .0744 L
s
.2619 .5506 m
.5 .5506 L
s
.2619 .0744 m
.5 .0744 L
s
.55952 .49107 m
.55952 .61012 L
.67857 .61012 L
.67857 .49107 L
.55952 .49107 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .61905 .5506 0 0 Mshowa
P
.5 .5506 m
.55952 .5506 L
s
.67857 .5506 m
.7381 .5506 L
s
.55952 .01488 m
.55952 .13393 L
.67857 .13393 L
.67857 .01488 L
.55952 .01488 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .61905 .0744 0 0 Mshowa
P
.5 .0744 m
.55952 .0744 L
s
.67857 .0744 m
.7381 .0744 L
s
newpath
.85714 .5506 .04762 0 365.73 arc
s
6 Mabswid
.85714 .0744 Mdot
1 Mabswid
.85714 .59821 m
.85714 .0744 L
s
.7381 .5506 m
.97619 .5506 L
s
.7381 .0744 m
.97619 .0744 L
s
.2619 .3125 m
.97619 .3125 L
s
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{178, 110},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002b0000KQ000`40O003h00O/Woo002bOol00;9o
o`00HWoo5P00>Woo001ROol00`00Oomoo`0BOol00`00Oomoo`0hOol001Qoo`H004Aoo`03001oogoo
019oo`03001oogoo03Qoo`005Woo0P000Woo00D007ooOomoo`0004=oo`03001oogoo019oo`03001o
ogoo03Qoo`0057oo0P0017oo00<007ooOol00Woo00<007ooOol0@7oo00<007ooOol04Woo00<007oo
Ool0>7oo000DOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0BOol0
0`00Oomoo`0hOol001=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo03moo`03001oogoo
019oo`03001oogoo03Qoo`004Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0?Woo00<0
07ooOol04Woo00<007ooOol0>7oo000BOol00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0M
Ool4000LOol00`00Oomoo`05Ool50008Ool00`00Oomoo`0KOol4000IOol0019oo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo01aoo`H001]oo`03001oogoo00Moo`03001oogoo00Qoo`03001o
ogoo01Yoo`H001Qoo`001GooGP002Goo00<007ooOol027oo=@001Woo000AOol00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`0LOol6000KOol00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomo
o`0JOol6000HOol0019oo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo01aoo`H001]oo`03
001oogoo00Aoo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Oomoo`0JOol6000HOol0019oo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo01eoo`@001aoo`03001oogoo00Aoo`04001oogoo
0002Ool00`00Oomoo`05Ool00`00Oomoo`0KOol4000IOol0019oo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo01moo`03001oogoo01aoo`03001oogoo00Aoo`L000Moo`03001oogoo01aoo`03
001oogoo01Uoo`004goo00<007ooOol017oo00<007ooOol017oo00<007ooOol07goo00<007ooOol0
77oo00<007ooOol04Woo00<007ooOol077oo00<007ooOol06Goo000DOol00`00Oomoo`03Ool00`00
Oomoo`02Ool2000ROol00`00Oomoo`0LOol00`00Oomoo`0BOol00`00Oomoo`0LOol00`00Oomoo`0I
Ool001Eoo`03001oogoo009oo`05001oogooOol0000TOol00`00Oomoo`0LOol00`00Oomoo`0BOol0
0`00Oomoo`0LOol00`00Oomoo`0IOol001Ioo`80009oo`04001oo`00000UOol00`00Oomoo`0LOol0
0`00Oomoo`0BOol00`00Oomoo`0LOol00`00Oomoo`0IOol001Qoo`@002Moo`03001oogoo01aoo`03
001oogoo019oo`03001oogoo01aoo`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0
77oo00<007ooOol04Woo00<007ooOol077oo00<007ooOol06Goo000JOol00`00Oomoo`0VOol00`00
Oomoo`0LOolF000NOol00`00Oomoo`0IOol001Yoo`03001oogoo02Ioo`03001oogoo051oo`03001o
ogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<007ooOol06Goo000JOol00`00Oomo
o`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001oogoo02Ioo`03001oogoo051oo`03
001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<007ooOol06Goo000JOol00`00
Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001oogoo02Ioo`03001oogoo051o
o`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<007ooOol06Goo000JOol0
0`00Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001oogoo02Ioo`03001oogoo
051oo`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<007ooOol06Goo000J
Ool00`00Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001oogoo02Ioo`03001o
ogoo051oo`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<007ooOol06Goo
000JOol00`00Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001oogoo02Ioo`03
001oogoo051oo`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<007ooOol0
6Goo000JOol00`00Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001oogoo02Io
o`03001oogoo051oo`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<007oo
Ool06Goo000JOol00`00Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001oogoo
02Ioo`03001oogoo051oo`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo00<0
07ooOol06Goo000JOol00`00Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Yoo`03001o
ogoo02Ioo`03001oogoo051oo`03001oogoo01Uoo`006Woo00<007ooOol09Woo00<007ooOol0D7oo
00<007ooOol06Goo000JOol00`00Oomoo`0VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol001Qoo`@0
02Moo`03001oogoo051oo`03001oogoo01Uoo`005goo1P009Woo00<007ooOol0D7oo00<007ooOol0
6Goo000GOol6000VOol00`00Oomoo`1@Ool00`00Oomoo`0IOol000EoojL000Ioo`005goo1P009Woo
00<007ooOol0D7oo00<007ooOol06Goo000HOol4000WOol00`00Oomoo`1@Ool00`00Oomoo`0IOol0
04=oo`03001oogoo051oo`03001oogoo01Uoo`00@goo00<007ooOol0D7oo00<007ooOol06Goo0013
Ool00`00Oomoo`1@Ool00`00Oomoo`0IOol004=oo`03001oogoo051oo`03001oogoo01Uoo`00@goo
00<007ooOol0D7oo00<007ooOol06Goo0013Ool00`00Oomoo`1@Ool00`00Oomoo`0IOol004=oo`03
001oogoo051oo`03001oogoo01Uoo`00@goo00<007ooOol0D7oo00<007ooOol06Goo0013Ool00`00
Oomoo`1@Ool00`00Oomoo`0IOol004=oo`03001oogoo051oo`03001oogoo01Uoo`00@goo00<007oo
Ool0D7oo00<007ooOol06Goo0013Ool00`00Oomoo`1@Ool00`00Oomoo`0IOol004=oo`03001oogoo
051oo`03001oogoo01Uoo`00@goo00<007ooOol0D7oo00<007ooOol06Goo0013Ool00`00Oomoo`1@
Ool00`00Oomoo`0IOol004=oo`03001oogoo051oo`03001oogoo01Uoo`00@goo00<007ooOol0D7oo
00<007ooOol06Goo0013Ool00`00Oomoo`1@Ool00`00Oomoo`0IOol004=oo`03001oogoo051oo`03
001oogoo01Uoo`00@goo00<007ooOol0D7oo00<007ooOol06Goo0013Ool00`00Oomoo`1@Ool00`00
Oomoo`0IOol004=oo`03001oogoo051oo`03001oogoo01Uoo`00@goo00<007ooOol0D7oo00<007oo
Ool06Goo0013Ool00`00Oomoo`1@Ool00`00Oomoo`0IOol004=oo`03001oogoo051oo`03001oogoo
01Uoo`00@goo00<007ooOol0D7oo00<007ooOol06Goo0013Ool00`00Oomoo`1@Ool00`00Oomoo`0I
Ool004=oo`03001oogoo051oo`03001oogoo01Uoo`003goo5P007Woo00<007ooOol077oo5P007Woo
00<007ooOol06Goo000?Ool00`00Oomoo`0BOol00`00Oomoo`0LOol00`00Oomoo`0LOol00`00Oomo
o`0BOol00`00Oomoo`0LOol00`00Oomoo`0IOol000moo`03001oogoo019oo`03001oogoo01]oo`<0
01eoo`03001oogoo019oo`03001oogoo01]oo`@001Uoo`003goo00<007ooOol04Woo00<007ooOol0
6Goo0P0000=oo`00Ool010006Goo00<007ooOol04Woo00<007ooOol06Goo0P0000Aoo`00Oomoo`<0
01Ioo`003goo00<007ooOol04Woo00<007ooOol05goo0P000goo00<007ooOol00goo00<007ooOol0
5Woo00<007ooOol04Woo00<007ooOol05goo0P000goo00<007ooOol00goo00<007ooOol04goo000?
Ool00`00Oomoo`0BOol00`00Oomoo`0GOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0E
Ool00`00Oomoo`0BOol00`00Oomoo`0GOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0B
Ool000moo`03001oogoo019oo`03001oogoo01Ioo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo01Eoo`03001oogoo019oo`03001oogoo01Ioo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo019oo`003goo00<007ooOol04Woo00<007ooOol05Goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol057oo00<007ooOol04Woo00<007ooOol05Goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol04Goo000?Ool00`00Oomoo`0BOol00`00Oomoo`0DOol00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`0DOol00`00Oomoo`0BOol00`00Oomoo`0DOol00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`0AOol000moo`03001oogoo00Eoo`@000Uoo`03001oogoo01Aoo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo01Aoo`03001oogoo00Eoo`@000Uoo`03001oogoo01Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo015oo`003goo00<007ooOol01Goo00D007ooOomo
o`0000Qoo`03001oogoo01Aoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo01=oo`03001o
ogoo00Eoo`05001oogooOol00008Ool00`00Oomoo`0DOol00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`0@Ool000Eoo`/000]oo`03001oogoo00Ioocl000]oo`03001oogoo00IoocD000Ioo`00
3goo00<007ooOol01Woo0`002Goo00<007ooOol057oo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol057oo00<007ooOol01Woo0`002Goo00<007ooOol057oo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol04Goo000?Ool00`00Oomoo`05Ool00`00Oomoo`0:Ool00`00Oomoo`0DOol00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0DOol00`00Oomoo`05Ool00`00Oomoo`0:Ool00`00
Oomoo`0DOol00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0AOol000moo`03001oogoo00Eo
o`05001oogooOol00008Ool00`00Oomoo`0DOol00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`0DOol00`00Oomoo`05Ool01@00Oomoogoo000027oo00<007ooOol057oo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol04Goo000?Ool00`00Oomoo`06Ool40008Ool00`00Oomoo`0EOol00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`0EOol00`00Oomoo`06Ool40008Ool00`00Oomoo`0E
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`0BOol000moo`03001oogoo019oo`03001o
ogoo01Ioo`8000Aoo`03001oogoo009oo`8001Qoo`03001oogoo019oo`03001oogoo01Ioo`8000Ao
o`03001oogoo009oo`8001Eoo`003goo00<007ooOol04Woo00<007ooOol067oo00D007ooOomoo`00
00=oo`03001oogoo01Qoo`03001oogoo019oo`03001oogoo01Qoo`05001oogooOol00003Ool00`00
Oomoo`0EOol000moo`03001oogoo019oo`03001oogoo01Uoo`04001oogoo0002Ool00`00Oomoo`0I
Ool00`00Oomoo`0BOol00`00Oomoo`0IOol01000Oomoo`000Woo00<007ooOol05Woo000?Ool00`00
Oomoo`0BOol00`00Oomoo`0JOol5000LOol00`00Oomoo`0BOol00`00Oomoo`0JOol5000IOol000mo
o`03001oogoo019oo`03001oogoo03]oo`03001oogoo019oo`03001oogoo03Qoo`003goo5P00?Goo
5P00>Woo002bOol00;9oo`00\
\>"],
  ImageRangeCache->{{{0, 177}, {109, 0}} -> {4.86869, -0.312514, 0.0240828, 
  0.0240828}}]
}, Open  ]],

Cell["In the present example", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Step4[b1_, b2_, state_]:=
\t(XORGate[3,1,3] .
\t TOP[3,3] .
\t SOP[1,3] .
\t XORGate[3,1,3] .
\t XORGate[2,3,3] .
\t SOP[1,3] . 
\t KetToColumnVector[Direct[ket[b1], ket[b2], StateOnLine3[state]]]
\t) // Chop // ColumnVectorToKet

StateOnLine3[a_. ket[b1_,b2_,b30_] + b_. ket[b1_,b2_,b31_]]:=
\ta ket[b30] + b ket[b31]\t
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["outputState = Step4[line1Bit, line2Bit, state3]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.5`\ ket[1, 1, 0] + 0.866025403784438552`\ ket[1, 1, 1]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["StateOnLine3[outputState]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.5`\ ket[0] + 0.866025403784438552`\ ket[1]\)], "Output"]
}, Open  ]],

Cell["\<\
Does this match the original state? As a check ask for the value of \
unknownState.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["unknownState", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["0.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->1], " ", \(ket[0]\)}], "+", 
      \(0.866025403784438552`\ ket[1]\)}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Teleport Command", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
We now bundle all these steps together into a self-documenting \
program called Teleport.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?Teleport", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \("Teleport[state] generates a self-documenting simulation of the  \
process of teleporting the given state from Alice to Bob."\)], "Print"]
}, Open  ]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .30693 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.049505 0.0990099 0.0693069 0.0990099 [
[ 0 0 0 0 ]
[ 1 .30693 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .30693 L
0 .30693 L
closepath
clip
newpath
p
p
1 Mabswid
.07426 .14356 m
.07426 .19307 L
.12376 .19307 L
.12376 .14356 L
.07426 .14356 L
s
p
/Courier findfont 12 scalefont setfont
[(L)] .09901 .16832 0 0 Mshowa
P
.0495 .16832 m
.07426 .16832 L
s
.12376 .16832 m
.14851 .16832 L
s
newpath
.19802 .06931 .0198 0 365.73 arc
s
6 Mabswid
.19802 .16832 Mdot
1 Mabswid
.19802 .0495 m
.19802 .16832 L
s
.14851 .06931 m
.24752 .06931 L
s
.14851 .16832 m
.24752 .16832 L
s
.0495 .06931 m
.14851 .06931 L
s
P
p
1 Mabswid
newpath
.29703 .16832 .0198 0 365.73 arc
s
6 Mabswid
.29703 .26733 Mdot
1 Mabswid
.29703 .14851 m
.29703 .26733 L
s
.24752 .16832 m
.34653 .16832 L
s
.24752 .26733 m
.34653 .26733 L
s
.37129 .24257 m
.37129 .29208 L
.42079 .29208 L
.42079 .24257 L
.37129 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(R)] .39604 .26733 0 0 Mshowa
P
.34653 .26733 m
.37129 .26733 L
s
.42079 .26733 m
.44554 .26733 L
s
.34653 .16832 m
.44554 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|y>)] 0 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .06931 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|0>)] 0 .16832 -1 0 Mshowa
P
P
p
p
/Symbol findfont 10 scalefont setfont
[(r)] .45545 .08911 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(s)] .24752 .18812 0 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(?)] .45545 .26733 -1 0 Mshowa
P
1 Mabswid
.24752 .06931 m
.54455 .06931 L
s
.0495 .26733 m
.24752 .26733 L
s
P
p
1 Mabswid
newpath
.59406 .06931 .0198 0 365.73 arc
s
6 Mabswid
.59406 .16832 Mdot
1 Mabswid
.59406 .0495 m
.59406 .16832 L
s
.54455 .06931 m
.64356 .06931 L
s
.54455 .16832 m
.64356 .16832 L
s
.56931 .24257 m
.56931 .29208 L
.61881 .29208 L
.61881 .24257 L
.56931 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .59406 .26733 0 0 Mshowa
P
.54455 .26733 m
.56931 .26733 L
s
.61881 .26733 m
.64356 .26733 L
s
newpath
.69307 .26733 .0198 0 365.73 arc
s
6 Mabswid
.69307 .06931 Mdot
1 Mabswid
.69307 .28713 m
.69307 .06931 L
s
.64356 .26733 m
.74257 .26733 L
s
.64356 .06931 m
.74257 .06931 L
s
.76733 .24257 m
.76733 .29208 L
.81683 .29208 L
.81683 .24257 L
.76733 .24257 L
s
p
/Courier findfont 12 scalefont setfont
[(S)] .79208 .26733 0 0 Mshowa
P
.74257 .26733 m
.76733 .26733 L
s
.81683 .26733 m
.84158 .26733 L
s
.76733 .04455 m
.76733 .09406 L
.81683 .09406 L
.81683 .04455 L
.76733 .04455 L
s
p
/Courier findfont 12 scalefont setfont
[(T)] .79208 .06931 0 0 Mshowa
P
.74257 .06931 m
.76733 .06931 L
s
.81683 .06931 m
.84158 .06931 L
s
newpath
.89109 .26733 .0198 0 365.73 arc
s
6 Mabswid
.89109 .06931 Mdot
1 Mabswid
.89109 .28713 m
.89109 .06931 L
s
.84158 .26733 m
.94059 .26733 L
s
.84158 .06931 m
.94059 .06931 L
s
.64356 .16832 m
.94059 .16832 L
s
P
p
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .26733 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|f>)] .9505 .16832 -1 0 Mshowa
P
p
/Symbol findfont 10 scalefont setfont
[(|y>)] .9505 .06931 -1 0 Mshowa
P
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.06188 .03218 m
.06188 .30446 L
.43317 .30446 L
.43317 .03218 L
.06188 .03218 L
s
[(Alice)] .24752 .0099 0 0 Mshowa
P
p
[ .01 .01 ] 0 setdash
1 Mabswid
.55693 .03218 m
.55693 .30446 L
.92822 .30446 L
.92822 .03218 L
.55693 .03218 L
s
[(Bob)] .74257 .0099 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{340, 104},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005D0000J1000`40O003h00OogooEGoo003oOomE
Ool00?mooeEoo`00B7oo0P0000Aoo`00001oo`T00003Ool0000000=oo`<009=oo`D0009oo`80009o
o`<005=oo`00BGoo0`000goo00<007ooOol00Woo00@007ooOol0009oo`03001oo`0009Moo`06001o
ogoo001oo`000Woo00<007oo00000Woo00<007ooOol0D7oo0019Ool00`00Ool00003Ool00`00Oomo
o`02Ool01000Oomoo`000Woo00<007oo00000`00U7oo100000Moo`00Oomoo`00Ool00002Ool00`00
Oomoo`1@Ool004Yoo`8000=oo`04001oogooOol20003Ool30002Ool2002EOol01000Oomoo`000Woo
0P000Woo0`00Dgoo0019Ool20004Ool00`00Oomoo`2QOol50006Ool00`00Oomoo`1COol004ioo`80
00Aoo`03001oogoo0:Ioo`8005Eoo`00ogooEGoo003oOomEOol001Ioo`<000=oo`@0009oo`D0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009o
o`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@002Yoo`@0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@0009oo`D0009oo`D0009oo`@000=oo`@0009oo`D0009oo`@000=oo`@0009oo`D0009o
o`@000=oo`@000=oo`@0009oo`D0009oo`@001aoo`005Woo00<007ooOol0Xgoo00<007ooOol0UGoo
000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03
001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yoo`03001oogoo01Qoo`005Woo00<007ooOol0
NWoo00<007ooOol09Woo00<007ooOol0A7oo4@009Goo00<007ooOol067oo002COol00`00Oomoo`1]
Ool00`00Oomoo`0=Ool00`00Oomoo`0SOol00`00Oomoo`0HOol0045oo`H004aoo`03001oogoo031o
o`H003Moo`03001oogoo00eoo`03001oogoo02=oo`03001oogoo01Qoo`005Woo00<007ooOol09goo
00D007ooOomoo`00009oo`8007=oo`03001oogoo00Ioo`05001oogooOol00002Ool2000eOol00`00
Oomoo`0=Ool00`00Oomoo`0nOol001Ioo`03001oogoo02Ioo`03001oogoo009oo`03001oogoo009o
o`03001oogoo071oo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo039o
o`03001oogoo00eoo`03001oogoo03ioo`000Woo00<007ooOol04Goo00<007ooOol09Woo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol09Woo00<007ooOol01Goo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol0<Woo00<007ooOol03Goo00<007ooOol08goo00<007oo
Ool01Goo00<007ooOol047oo0002Ool00`00Oomoo`0AOol00`00Oomoo`0UOol00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0VOol00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`03Ool00`00Oomoo`0FOol4000GOol00`00Oomoo`0=Ool00`00Oomoo`0EOol4000:Ool0
0`00Oomoo`05Ool01@00Oomoogoo00003Woo0002Ool00`00Oomoo`0iOol00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`16Ool00`00Oomoo`0]Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`0EOol6000FOol00`00Oomoo`02Ool50006Ool00`00Oomoo`0DOol60009Ool00`00Oomoo`05
Ool01@00Oomoogoo00003Woo0002Ool01000Ool000000Woo0P00<goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol0AWoo00<007ooOol0;7oo00<007ooOol017oo00<007ooOol00goo00<007oo
Ool05Goo1P005Woo00<007ooOol017oo00<007ooOol01Woo00<007ooOol057oo1P002Goo00<007oo
Ool01Goo00<007ooOol00`000Woo0P002Goo0002Ool20002Ool01000Oomoogoo0P001WoolP001Woo
00<007ooOol01Woo:`000goo00L007oo001oo`00Ool00003Ool20007Ool0009oo`80009oo`03001o
ogoo00=oo`03001oogoo00Moo`03001oogoo02Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001o
ogoo06moo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo01Eoo`H001Io
o`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo01Aoo`H0015oo`07001oo`00Ool007oo0000
1Goo00<007ooOol017oo0002Ool20002Ool01000Oomoogoo0P002Woo00<007ooOol097oo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol0Kgoo00<007ooOol00goo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol05Woo10005goo00D007ooOomoo`00009oo`04001oogoo0005Ool00`00Oomo
o`0EOol4000BOol01`00Ool007oo001oo`0000=oo`8000Moo`000Woo0P000Woo00@007oo000000ao
o`03001oogoo02Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo04Ioo`03001oogoo00Eo
o`03001oogoo01ioo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo01Qo
o`03001oogoo01Ioo`05001oogooOol00002Ool01000Oomoo`001Goo00<007ooOol05Woo00<007oo
Ool02Woo00<007ooOol01Goo0`0000Eoo`00Ool007oo008000Uoo`000Woo0P000Woo00<007ooOol0
3Goo00<007ooOol09Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Agoo00<007ooOol0
1Goo00<007ooOol07Woo00<007ooOol01Goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
6Goo00<007ooOol05Woo00@007ooOomoo`L000Eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001o
ogoo00Eoo`05001oogooOol0000>Ool0009oo`04001oo`00000jOol01@00Oomoogoo00000Woo0P00
BWoo00<007ooOol01Goo0`009goo00D007ooOomoo`00009oo`8001aoo`03001oogoo01Ioo`03001o
ogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011oo`000Woo
00<007ooOol0?7oo1P00C7oo00<007ooOol01Goo00@007ooOol002Moo`H001ioo`03001oogoo01Io
o`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo00Eoo`03001oogoo011o
o`005Woo00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo01Ioo`03001oogoo00eoo`03001oogoo01Ioo`03001oogoo02Eoo`005Woo
00<007ooOol0:goo00<007ooOol0E7oo00@007ooOol001eoo`03001oogoo00Yoo`03001oogoo01io
o`03001oogoo01Iooa4001Qoo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo
00<007ooOol01Woo0P007Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo000FOol00`00Oomoo`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol0
0`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`00A7oo00<007ooOol0C7oo00<0
07ooOol0<goo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014
Ool00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:
Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo07Eoo`03001oogoo00Yoo`03001o
ogoo01ioo`03001oogoo03moo`03001oogoo02Eoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo
00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0[Ool00`00Oomoo`1<Ool00`00Oomoo`0VOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomo
o`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo02]oo`03001oogoo04aoo`03
001oogoo02Ioo`03001oogoo00Yoo`03001oogoo01ioo`03001oogoo03moo`03001oogoo00Yoo`03
001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0C7oo00<007ooOol09Woo00<007ooOol0
2Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol067oo0014Ool00`00
Oomoo`1<Ool00`00Oomoo`0cOol00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`0HOol004Aoo`03001oogoo04aoo`03001oogoo03=oo`03001oogoo01ioo`03001oogoo03mo
o`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<007ooOol0MGoo00<007oo
Ool02Woo00<007ooOol07Woo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`0[Ool0
0`00Oomoo`1eOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0UOol0
01Ioo`03001oogoo02]oo`03001oogoo04aoo`03001oogoo02Ioo`03001oogoo00Yoo`03001oogoo
01ioo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0:goo00<0
07ooOol0C7oo00<007ooOol09Woo00<007ooOol02Woo00<007ooOol07Woo00<007ooOol0?goo00<0
07ooOol02Woo00<007ooOol067oo000JOolB000HOol00`00Oomoo`1<Ool00`00Oomoo`0cOol00`00
Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Yoo`03001oogoo00io
o`03001oogoo01Ioo`03001oogoo01eoo`@002]oo`03001oogoo03=oo`03001oogoo01ioo`03001o
ogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`006Woo00<007ooOol03Woo00<007ooOol05Woo
00<007ooOol06goo0P0000Eoo`00Oomoo`00061oo`03001oogoo01ioo`03001oogoo03moo`03001o
ogoo02Eoo`005Woo00D007ooOomoo`00011oo`03001oogoo01Ioo`03001oogoo01Uoo`8000=oo`05
001oogooOol0001BOol00`00Oomoo`0:Ool00`00Oomoo`0NOol00`00Oomoo`0oOol00`00Oomoo`0U
Ool0009oo`03001oogoo015oo`05001oogooOol0000@Ool00`00Oomoo`0FOol00`00Oomoo`0IOol0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1?Ool00`00Oomoo`0:Ool00`00Oomoo`0NOol0
0`00Oomoo`0oOol00`00Oomoo`0BOol00`00Oomoo`0@Ool0009oo`03001oogoo015oo`05001oogoo
Ool0000@Ool00`00Oomoo`0DOol4000IOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0V
Ool00`00Oomoo`0VOol00`00Oomoo`08Ool4000OOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00
Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0AOol01@00Oomoogoo00001Goo1P001Goo
00<007ooOol04goo1P0067oo00<007ooOol00goo00<007ooOol00goo00<007ooOol09Goo00<007oo
Ool09Woo00<007ooOol01goo1P007Woo00<007ooOol0?goo00<007ooOol02Woo00<007ooOol01Goo
00@007ooOol000moo`000Woo00@007oo0000009oo`80011oo`03001oogoo00Aoo`05001oogooOol0
0005Ool00`00Oomoo`0COol6000GOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0UOol0
0`00Oomoo`06Ool00`00Oomoo`0WOol6000NOol00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool00`00Ool0000200000goo0000000;Ool0009oo`80009oo`04001oogooOol20006Ool90006
Ool01@00Oomoogoo00001GooK@0087ooQP000goo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0P00
0Woo00<007ooOol00goo00<007ooOol01goo00D007ooOomoo`0000Ioo`03001oogoo00Moo`03001o
ogoo01=oo`H001Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo04eoo`03001oogoo00Mo
o`H001ioo`03001oogoo03moo`03001oogoo019oo`800004Ool007oo0004Ool00`00Oomoo`06Ool0
009oo`80009oo`04001oogooOol2000:Ool01@00Oomoogoo00001Woo00<007ooOol01goo00<007oo
Ool057oo10006Goo00<007ooOol00goo00<007ooOol00goo00<007ooOol0;Woo00<007ooOol07Goo
00<007ooOol027oo10007goo00<007ooOol0?goo00<007ooOol04Woo0P0000Aoo`00Ool0009oo`80
00Uoo`000Woo0P000Woo00@007oo000000aoo`05001oogooOol00006Ool00`00Oomoo`07Ool00`00
Oomoo`0aOol00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomoo`07Ool00`00
Oomoo`0LOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00
Ool0000200000goo0000000;Ool0009oo`80009oo`03001oogoo00eoo`05001oogooOol00005Ool4
0007Ool00`00Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0UOol00`00Oomo
o`05Ool00`00Ool0000NOol00`00Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomo
o`05Ool01000Oomoo`003goo0002Ool01000Ool0000047oo00D007ooOomoo`00011oo`03001oogoo
039oo`8000=oo`04001oogooOol2000XOol00`00Oomoo`05Ool3000NOol00`00Oomoo`0[Ool00`00
Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`05Ool01000Oomoo`003goo0002Ool00`00Oomoo`0E
Ool00`00Oomoo`0>Ool00`00Oomoo`0UOol3000<Ool7000ZOol00`00Oomoo`1DOol00`00Oomoo`0o
Ool00`00Oomoo`0:Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool001Yoo`03001oogoo00ioo`03001o
ogoo02Aoo`05001oogooOol0000>Ool00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`04001oogooOolB000VOol01@00Oomoogoo00003Woo
00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomo
o`0iOol01@00Oomoogoo00003Woo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`0jOol5000=Ool00`00Oomoo`0[Ool00`00Oomoo`0VOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0:Ool00`00Oomoo`0HOol001Ioo`03001oogoo04ao
o`03001oogoo02]oo`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yo
o`03001oogoo01Qoo`00IGoo00<007ooOol0:goo00<007ooOol0E7oo00<007ooOol0?goo00<007oo
Ool02Woo00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol0
0`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo089oo`03001oogoo03moo`03001oogoo
02Eoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0:goo00<007ooOol0?goo00<0
07ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00Oomoo`0[Ool00`00Oomoo`0o
Ool00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]oo`03001oogoo02Ioo`03001o
ogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo
00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007ooOol0?goo00<007ooOol02Woo
00<007ooOol067oo001UOol00`00Oomoo`0[Ool00`00Oomoo`1DOol00`00Oomoo`0oOol00`00Oomo
o`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo02]oo`03001oogoo05Aoo`03001oogoo03moo`03
001oogoo00Yoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007ooOol0E7oo00<007ooOol0
:goo00<007ooOol0?goo00<007ooOol09Goo000FOol00`00Oomoo`1<Ool00`00Oomoo`1DOol00`00
Oomoo`0[Ool00`00Oomoo`0oOol00`00Oomoo`0UOol001Ioo`03001oogoo04aoo`03001oogoo02]o
o`03001oogoo02Ioo`03001oogoo02]oo`03001oogoo03moo`03001oogoo00Yoo`03001oogoo01Qo
o`005Woo00<007ooOol0C7oo00<007ooOol0:goo00<007ooOol09Woo00<007ooOol0:goo00<007oo
Ool0?goo00<007ooOol02Woo00<007ooOol067oo000FOol00`00Oomoo`1<Ool00`00Oomoo`0FOolA
0004Ool00`00Oomoo`0VOol01000Oomoogoo4P0067oo00<007ooOol05Woo4@0067oo00<007ooOol0
2Woo00<007ooOol067oo001UOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00
Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0FOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00
Oomoo`0FOol00`00Oomoo`0:Ool00`00Oomoo`0HOol006Eoo`03001oogoo01Ioo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo02Yoo`03001oogoo00ioo`03001oogoo01=oo`L001Eoo`03001o
ogoo00eoo`03001oogoo01=oo`L000Uoo`03001oogoo01Qoo`005Woo00<007ooOol0C7oo00<007oo
Ool05Woo00<007ooOol03Goo00<007ooOol0:goo00D007ooOomoo`00011oo`03001oogoo015oo`80
00=oo`05001oogooOol0000DOol00`00Oomoo`0=Ool00`00Oomoo`0BOol01@00Oomoogoo00000goo
00<007ooOol08Goo0002Ool00`00Oomoo`0AOol00`00Oomoo`1<Ool00`00Oomoo`0FOol00`00Oomo
o`0=Ool00`00Oomoo`0[Ool01@00Oomoogoo000047oo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol04Goo00<007ooOol03Goo00<007ooOol04Goo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol047oo0002Ool01@00Oomoogoo00003goo00<007oo
Ool0C7oo00<007ooOol05Woo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol09Woo00D007oo
Oomoo`00011oo`03001oogoo011oo`03001oogoo00=oo`03001oogoo009oo`03001oogoo015oo`03
001oogoo00eoo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`03
001oogoo00Eoo`04001oogoo000?Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1:Ool4000G
Ool01000Oomoogoo0`000Woo0P001Goo00<007ooOol00Woo00<007ooOol09Woo00D007ooOomoo`00
00Eoo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03
001oogoo009oo`@000Moo`03001oogoo011oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo
00=oo`03001oogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo00<0009oo`8005Ioo`H001Io
o`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`0QOol00`00Oomoo`03Ool01@00Oomoogoo00001Woo00<007ooOol03goo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol047oo00<007ooOol00Woo00D007ooOomoo`0000Ioo`03001oogoo011o
o`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo00Eoo`03001oo`000080
0003Ool0000000]oo`000Woo00L007oo001oo`00Ool00003Ool20004Oom]0004Ool01000Oomoo`00
1goo2P0087oo2@002Goo00<007ooOol017oo<`0027oo00<007ooOol017oo:`000goo0P0000Aoo`00
Ool0009oo`8000Uoo`000Woo00L007oo001oo`00Ool00005Ool00`00Oomoo`1AOol6000FOol00`00
Oomoo`02Ool40007Ool00`00Oomoo`0_Ool00`00Oomoo`04Ool30007Ool00`00Oomoo`0?Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool30007Ool00`00Oomoo`0@
Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool2000017oo001oo`0017oo00<007oo
Ool01Woo0002Ool01`00Ool007oo001oo`0000=oo`8000Qoo`03001oogoo04Uoo`H001Ioo`03001o
ogoo009oo`05001oogooOol00006Ool00`00Oomoo`0;Ool00`00Oomoo`0MOol01@00Oomoogoo0000
1Goo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol00goo00<007ooOol0
47oo00<007ooOol00Woo00<007ooOol027oo00<007ooOol047oo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol037oo0P0000Aoo`00Ool0009oo`8000Uoo`000Woo0`0000Eoo`00Ool007oo0080
00Yoo`03001oogoo04Yoo`@001Moo`03001oogoo009oo`05001oogooOol00006Ool00`00Oomoo`0<
Ool00`00Oomoo`0LOol01@00Oomoogoo00001Goo00D007ooOomoo`0000Ioo`03001oogoo011oo`03
001oogoo00=oo`03001oogoo00=oo`03001oogoo011oo`03001oogoo009oo`05001oogooOol00006
Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0<Ool00`00Ool00002
00000goo0000000;Ool0009oo`05001oogooOol0000?Ool00`00Oomoo`1UOol01000Oomoogoo1@00
1goo00<007ooOol00Woo00<007ooOol01Goo00<007oo00007Woo00D007ooOomoo`0000Ioo`@000Io
o`03001oogoo015oo`03001oogoo009oo`03001oogoo009oo`03001oogoo015oo`03001oogoo00=o
o`@000Ioo`03001oogoo015oo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Aoo`03001o
ogoo00Eoo`04001oogoo000?Ool0009oo`03001oogoo015oo`03001oogoo06Eoo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo00Eoo`<001ioo`05001oogooOol0000@Ool00`00Oomoo`0AOol2
0003Ool00`00Oomoo`02000DOol00`00Oomoo`0=Ool00`00Oomoo`0AOol30002Ool01000Oomoogoo
0P001goo00<007ooOol01Goo00@007ooOol000moo`000Woo00<007ooOol0NGoo00<007ooOol03Goo
00<007ooOol00Woo00<007ooOol0:Woo00<007ooOol03Woo00<007ooOol04goo1P005Woo00<007oo
Ool03Goo00<007ooOol057oo0`0000=oo`0000002Goo00<007ooOol01Goo00<007ooOol047oo001n
Ool00`00Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`0ZOol00`00Oomoo`0>Ool00`00Oomoo`0F
Ool00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`0FOol2000;Ool00`00Oomoo`0HOol007io
o`03001oogoo00eoo`03001oogoo02moo`03001oogoo00ioo`03001oogoo02moo`03001oogoo00eo
o`03001oogoo03ioo`005Woo00<007ooOol0IGoo4@00;Goo00@007ooOomooa80035ooa40041oo`00
5Woo00<007ooOol0Xgoo00<007ooOol0UGoo000FOol00`00Oomoo`1jOol00`00Oomoo`0VOol00`00
Oomoo`1jOol00`00Oomoo`0HOol001Ioo`03001oogoo07Yoo`03001oogoo02Ioo`03001oogoo07Yo
o`03001oogoo01Qoo`006Goo10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000goo
10000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo
10000Woo0`00:goo10000Woo1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo
1@000Woo10000goo10000Woo1@000Woo1@000Woo10000goo10000Woo1@000Woo10000goo10000Woo
0`006Woo0000\
\>"],
  ImageRangeCache->{{{0, 339}, {103, 0}} -> {-0.551496, -0.700015, 0.0300973, 
  0.0300973}}],

Cell[CellGroupData[{

Cell["Code for teleportation simnulation in here ...", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
CreateUnknownState[]:=
\tModule[{a,b},
\t\ta = N[Random[Real,{-1,1}] Exp[I Random[Real,{0, N[2 Pi]}]]];
\t\tb = Sqrt[1-Abs[a]^2];
\t\ta ket[0] + b ket[1]
\t]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\

Options[Teleport] = {TraceProgress->True};

Teleport[unknownState_, opts___]:=
\tModule[{ebit, state2, bit1, bit2, state3, state4},
\t\ttraceQ = TraceProgress /. {opts} /. Options[Teleport];
\t\tIf[traceQ,
\t\t   (Print[\"The state to be teleported is: \", unknownState];
\t\t    Print[\"This state is unknown to both Alice and Bob.\\n\\n\"])];
\t\tebit   = Step1[ket[0], ket[0]];
\t\tIf[traceQ,
\t\t   (Print[\"Step 1:\"];
\t\t    Print[\"Alice creates a pair of ebits in the joint state: 1/Sqrt[2] \
(|00>+|11>)\"];
\t\t    Print[\"Alice keeps one ebit and sends the other to Bob.\\n\\n\"])];
\t\tstate2 = Step2[unknownState, ket[0], ket[0]];
\t\tIf[traceQ,
\t\t   (Print[\"Step 2:\"];
\t\t    Print[\"Alice entangles the unknown state with the ebit she retained \
in Step 1.\"]
\t\t    Print[\"To do this, Alice pushes the states:\"];
\t\t    Print[\"   \"<>ToString[unknownState]];
\t\t    Print[\"   |0>\"];
\t\t    Print[\"   |0>\"];
\t\t    Print[\"through her circuit.\"];
\t\t    Print[\"The resulting state (at the mid-point of the circuit) is:\"];
\t\t    Print[state2];
\t\t    Print[\"\\n\"])];
\t\t{{bit1,bit2}, state3} = Step3[state2];
\t\tIf[traceQ,
\t\t   (Print[\"Step 3:\"];
\t\t    Print[\"Alice measures the state on lines 1 and 2 to obtain the bits: \
\", {bit1, bit2}];
\t\t    Print[\"   and conveys these results to Bob via a classical 2-bit \
message.\\n\\n\"];
\t\t   )];
\t\tstate4 = Step4[bit1, bit2, state3];
\t\tIf[traceQ,
\t\t   (Print[\"Step 4:\"];
\t\t    Print[\"Bob receives Alices classical 2-bit message and creates \
the\"];
\t\t    Print[\"   inputs |\"<>ToString[bit1]<>\"> and \
|\"<>ToString[bit2]<>\"> for input to line 1 and line 2 of his circuit.\"];
\t\t    Print[\"Because of the ebit Alice created, and the measurement she \
made,\"];
\t\t    Print[\"   the state on line 3 entering Bob's circuit is:\"];
\t\t    Print[StateOnLine3[state3]];
\t\t    Print[\"\\n\\n\"]
\t\t   )
\t\t  ];
\t\t  If[traceQ,
\t\t     (Print[\"Step 5:\"];
\t\t      Print[\"Bob pushes the three states:\"];
\t\t      Print[\"   |\"<>ToString[bit1]<>\">,\"];
\t\t      Print[\"   |\"<>ToString[bit2]<>\"> and \"];
\t\t      Print[\"   \"<>ToString[StateOnLine3[state3]]];
\t\t      Print[\"through his circuit to obtain the output:\"];
\t\t      Print[\"   \"<>ToString[state4]];
\t\t      Print[\"Thus the state on line 3 of the output is:\"];
\t\t      Print[\"   \"<>ToString[StateOnLine3[state4]]];
\t\t      Print[\"Compare this with the \\\"unknown\\\" state on line 1 of \
Alice's input:\"];
\t\t      Print[\"   \"<>ToString[unknownState]];
\t\t      Print[\"They are the same!\"];
\t\t      Print[\"Thus the unknown state on line 1 of the input has been \
teleported to line 3 of the output.\"]
\t\t     )
\t\t    ];
\t\tStateOnLine3[state4]
\t]

Teleport::usage =
\t\"Teleport[state] generates a self-documenting simulation of the \\
\tprocess of teleporting the given state from Alice to Bob.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Syntax::"newl" \( : \ \) 
      "The newline character after \"\!\(\"\\t\\t    Print[\\\"Alice \
entangles the\" \\[Ellipsis] \"he ebit she retained in Step 1.\\\"]\"\)\" is \
understood as a multiplication operator.\!\(\"\\n\"\)"\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell["?Teleport", "Input",
  AspectRatioFixed->True],

Cell["\<\
Global`Teleport

Teleport[state1_, state2_, state3_] := Teleport[Direct[state1, state2, \
state3]]
 
Teleport[directProduct_List] := 
  ColumnVectorToKet[TeleportationCircuit[] . directProduct]
 
Teleport[state_] := 
  ColumnVectorToKet[TeleportationCircuit[] . KetToColumnVector[state]]
 
Teleport[unknownState_, opts___] := 
  Module[{ebit, state2, bit1, bit2, state3, state4}, 
   traceQ = TraceProgress /. {opts} /. Options[Teleport]; 
    If[traceQ, Print[\"The state to be teleported is: \", unknownState]; 
      Print[\"This state is unknown to both Alice and Bob.\\n\\n\"]]; 
    ebit = Step1[ket[0], ket[0]]; If[traceQ, 
     Print[\"Step 1:\"]; Print[\"Alice creates a pair of ebits in the joint \
state:\\
        1/Sqrt[2] (|00>+|11>)\"]; Print[\"Alice keeps one ebit and sends the \
other to\\
        Bob.\\n\\n\"]]; state2 = Step2[unknownState, ket[0], ket[0]]; 
    If[traceQ, Print[\"Step 2:\"]; Print[\"Alice entangles the unknown state \
with\\
         the ebit she retained in Step 1.\"]*
       Print[\"To do this, Alice pushes the states:\"]; 
      Print[StringJoin[\"   \", ToString[unknownState]]]; Print[\"   |0>\"]; 
      Print[\"   |0>\"]; Print[\"through her circuit.\"]; 
      Print[\"The resulting state (at the mid-point of the circuit) is:\"]; 
      Print[state2]; Print[\"\\n\"]]; {{bit1, bit2}, state3} = Step3[state2]; \

    If[traceQ, Print[\"Step 3:\"]; Print[\"Alice measures the state on lines \
1 and 2\\
        to obtain the bits: \", {bit1, bit2}]; 
      Print[\"   and conveys these results to Bob via a classical 2-bit\\
        message.\\n\\n\"]; Null]; state4 = Step4[bit1, bit2, state3]; 
    If[traceQ, Print[\"Step 4:\"]; Print[\"Bob receives Alices classical \
2-bit\\
        message and creates the\"]; 
      Print[StringJoin[\"   inputs |\", ToString[bit1], \"> and |\", \
ToString[bit2]\\
         , \"> for input to line 1 and line 2 of his circuit.\"]]; 
      Print[\"Because of the ebit Alice created, and the measurement she \
made,\"]; 
      Print[\"   the state on line 3 entering Bob's circuit is:\"]; 
      Print[StateOnLine3[state3]]; Print[\"\\n\\n\"]]; 
    If[traceQ, Print[\"Step 5:\"]; Print[\"Bob pushes the three states:\"]; 
      Print[StringJoin[\"   |\", ToString[bit1], \">,\"]]; 
      Print[StringJoin[\"   |\", ToString[bit2], \"> and \"]]; 
      Print[StringJoin[\"   \", ToString[StateOnLine3[state3]]]]; 
      Print[\"through his circuit to obtain the output:\"]; 
      Print[StringJoin[\"   \", ToString[state4]]]; 
      Print[\"Thus the state on line 3 of the output is:\"]; 
      Print[StringJoin[\"   \", ToString[StateOnLine3[state4]]]]; 
      Print[\"Compare this with the \\\"unknown\\\" state on line 1 of \
Alice's input:\"]; 
      Print[StringJoin[\"   \", ToString[unknownState]]]; 
      Print[\"They are the same!\"]; 
      Print[\"Thus the unknown state on line 1 of the input has been \
teleported to\\
        line 3 of the output.\"]]; StateOnLine3[state4]]
 
Options[Teleport] = {TraceProgress -> True}\
\>", "Print",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["You can make ",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " generate a complete simulation of the teleportation process. To begin, \
you must generate an \"unknown\" state. To generate the unknown state, use \
CreateUnknownState[].",
    Editable->False,
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["unknownState = CreateUnknownState[]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((\(0.339247837202219137`\[InvisibleSpace]\) + 
            0.00744312814285844659`\ I)\)\ ket[0] + 
      0.940667584642452503`\ ket[1]\)], "Output"]
}, Open  ]],

Cell["\<\
The simply call Teleport[unknownState] and watch the sequence of \
steps as the state is teleported through the circuit.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Try me!", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Teleport[unknownState]", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      \("The state to be teleported is: "\[InvisibleSpace]\(\((
              \(0.339247837202219137`\[InvisibleSpace]\) + 
                0.00744312814285844659`\ I)\)\ ket[0] + 
          0.940667584642452503`\ ket[1]\)\),
      SequenceForm[ "The state to be teleported is: ", 
        Plus[ 
          Times[ 
            Complex[ 0.33924783720221913, 0.0074431281428584458], 
            ket[ 0]], 
          Times[ 0.94066758464245248, 
            ket[ 1]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("This state is unknown to both Alice and Bob.\n\n"\)], "Print"],

Cell[BoxData[
    \("Step 1:"\)], "Print"],

Cell[BoxData[
    \("Alice creates a pair of ebits in the joint state: 1/Sqrt[2] \
(|00>+|11>)"\)], "Print"],

Cell[BoxData[
    \("Alice keeps one ebit and sends the other to Bob.\n\n"\)], "Print"],

Cell[BoxData[
    \("Step 2:"\)], "Print"],

Cell[BoxData[
    \("Alice entangles the unknown state with the ebit she retained in Step \
1."\)], "Print"],

Cell[BoxData[
    \("To do this, Alice pushes the states:"\)], "Print"],

Cell[BoxData[
    \("   (0.339248 + 0.00744313 I) ket[0] + 0.940668 ket[1]"\)], "Print"],

Cell[BoxData[
    \("   |0>"\)], "Print"],

Cell[BoxData[
    \("   |0>"\)], "Print"],

Cell[BoxData[
    \("through her circuit."\)], "Print"],

Cell[BoxData[
    \("The resulting state (at the mid-point of the circuit) is:"\)], "Print"],

Cell[BoxData[
    \(\((\(0.169623918601109568`\[InvisibleSpace]\) + 
            0.00372156407142922329`\ I)\)\ ket[0, 0, 0] + 
      \((\(0.470333792321226251`\[InvisibleSpace]\) + 0.`\ I)\)\ 
        ket[0, 0, 1] + 
      \((\(0.470333792321226251`\[InvisibleSpace]\) + 0.`\ I)\)\ 
        ket[0, 1, 0] + 
      \((\(0.169623918601109568`\[InvisibleSpace]\) + 
            0.00372156407142922329`\ I)\)\ ket[0, 1, 1] - 
      \((\(0.169623918601109568`\[InvisibleSpace]\) + 
            0.00372156407142922329`\ I)\)\ ket[1, 0, 0] + 
      \((\(0.470333792321226251`\[InvisibleSpace]\) + 0.`\ I)\)\ 
        ket[1, 0, 1] + 
      \((\(0.470333792321226251`\[InvisibleSpace]\) + 0.`\ I)\)\ 
        ket[1, 1, 0] - 
      \((\(0.169623918601109568`\[InvisibleSpace]\) + 
            0.00372156407142922329`\ I)\)\ ket[1, 1, 1]\)], "Print"],

Cell[BoxData[
    \("\n"\)], "Print"],

Cell[BoxData[
    \("Step 3:"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Alice measures the state on lines 1 and 2 to obtain the bits: "\
\[InvisibleSpace]{1, 1}\),
      SequenceForm[ 
      "Alice measures the state on lines 1 and 2 to obtain the bits: ", {1, 
        1}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("   and conveys these results to Bob via a classical 2-bit message.\n\n\
"\)], "Print"],

Cell[BoxData[
    \("Step 4:"\)], "Print"],

Cell[BoxData[
    \("Bob receives Alices classical 2-bit message and creates the"\)], 
  "Print"],

Cell[BoxData[
    \("   inputs |1> and |1> for input to line 1 and line 2 of his \
circuit."\)], "Print"],

Cell[BoxData[
    \("Because of the ebit Alice created, and the measurement she made,"\)], 
  "Print"],

Cell[BoxData[
    \("   the state on line 3 entering Bob's circuit is:"\)], "Print"],

Cell[BoxData[
    \(\((\(0.940667584642452503`\[InvisibleSpace]\) + 0.`\ I)\)\ ket[0] - 
      \((\(0.339247837202219137`\[InvisibleSpace]\) + 
            0.00744312814285844659`\ I)\)\ ket[1]\)], "Print"],

Cell[BoxData[
    \("\n\n"\)], "Print"],

Cell[BoxData[
    \("Step 5:"\)], "Print"],

Cell[BoxData[
    \("Bob pushes the three states:"\)], "Print"],

Cell[BoxData[
    \("   |1>,"\)], "Print"],

Cell[BoxData[
    \("   |1> and "\)], "Print"],

Cell[BoxData[
    \("   (0.940668 + 0. I) ket[0] - (0.339248 + 0.00744313 I) ket[1]"\)], 
  "Print"],

Cell[BoxData[
    \("through his circuit to obtain the output:"\)], "Print"],

Cell[BoxData[
    \("   (0.339248 + 0.00744313 I) ket[1, 1, 0] + 0.940668 ket[1, 1, 1]"\)], 
  "Print"],

Cell[BoxData[
    \("Thus the state on line 3 of the output is:"\)], "Print"],

Cell[BoxData[
    \("   (0.339248 + 0.00744313 I) ket[0] + 0.940668 ket[1]"\)], "Print"],

Cell[BoxData[
    \("Compare this with the \"unknown\" state on line 1 of Alice's \
input:"\)], "Print"],

Cell[BoxData[
    \("   (0.339248 + 0.00744313 I) ket[0] + 0.940668 ket[1]"\)], "Print"],

Cell[BoxData[
    \("They are the same!"\)], "Print"],

Cell[BoxData[
    \("Thus the unknown state on line 1 of the input has been teleported to \
line 3 of the output."\)], "Print"],

Cell[BoxData[
    \(\((\(0.339247837202219137`\[InvisibleSpace]\) + 
            0.00744312814285844659`\ I)\)\ ket[0] + 
      0.940667584642452503`\ ket[1]\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Circuit diagrams in here ...", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Circuit1[]:=
\tGraphics[Join[{AbsoluteThickness[1]},
\t              DrawOP[\"L\", {0.5,1}],
\t              DrawXOR[{1.5,{0,1}}],
\t              {Line[{{0,0},{1,0}}]}
\t             ]
\t        ] 
\t               
Circuit2[]:=
\tGraphics[Join[{AbsoluteThickness[1]},
\t              DrawXOR[{2.5,{1,2}}],
\t              DrawOP[\"R\", {3.5,2}],
\t              {Line[{{3,1}, {4,1}}]}
\t             ] 
\t        ]
\t       
Circuit3[]:=
\tGraphics[Join[{AbsoluteThickness[1]},
\t              DrawXOR[{5.5,{0,1}}],
\t              DrawOP[\"S\", {5.5,2}],
\t              DrawXOR[{6.5,{2,0}}],
\t              DrawOP[\"S\", {7.5,2}],
\t              DrawOP[\"T\", {7.5,0}],
\t              DrawXOR[{8.5,{2,0}}],
\t              {Line[{{6,1},{9,1}}]}
\t             ] 
\t        ]
\t        
AliceCircuit[]:=
\tShow[Circuit1[], Circuit2[],
\t     Graphics[{AbsoluteThickness[1], 
\t               Line[{{0,2},{3,2}}], Line[{{2,0},{4,0}}]}],
\t     AspectRatio->Automatic]
\t     
BobCircuit[]:=
\tShow[Circuit3[],
\t     AspectRatio->Automatic]
\t     
\t  \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
AliceCreatesEbit[]:=
\tShow[Circuit1[],
\t     Graphics[{Text[FontForm[\"|0>\", {\"Symbol\",10}], {-0.25,0}, {-1,0}],
\t               Text[FontForm[\"|0>\", {\"Symbol\",10}], {-0.25,1}, {-1,0}],
\t               Text[FontForm[\"s\", {\"Symbol\",10}], {2.07,1}, {-1,0}],
\t               Text[FontForm[\"r\", {\"Symbol\",10}], {2.07,0}, {-1,0}]
\t              }],
\t     AspectRatio->Automatic]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
AliceEntanglesEbitWithUnknownState[]:=
\tShow[Circuit1[],
\t     Circuit2[],
\t     Graphics[{Text[FontForm[\"|y>\", {\"Symbol\",10}], {-0.25,2}, {-1,0}],
\t               Text[FontForm[\"|0>\", {\"Symbol\",10}], {-0.25,0}, {-1,0}],
\t               Text[FontForm[\"|0>\", {\"Symbol\",10}], {-0.25,1}, \
{-1,0}]}],
\t     AspectRatio->Automatic]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
DrawTeleportationCircuit[]:=
\tShow[Circuit1[],
\t     Circuit2[],
\t     Graphics[{Text[FontForm[\"|y>\", {\"Symbol\",10}], {-.5,2}, {-1,0}],
\t               Text[FontForm[\"|0>\", {\"Symbol\",10}], {-.5,0}, {-1,0}],
\t               Text[FontForm[\"|0>\", {\"Symbol\",10}], {-.5,1}, {-1,0}]}],
\t     Graphics[{Text[FontForm[\"r\", {\"Symbol\",10}], {4.1,0.2}, {-1,0}],
\t               Text[FontForm[\"s\", {\"Symbol\",10}], {2,1.2}],
\t               Text[FontForm[\"?\", {\"Symbol\",10}], {4.1,1}, {-1,0}],
\t               Text[FontForm[\"?\", {\"Symbol\",10}], {4.1,2}, {-1,0}],
\t               AbsoluteThickness[1], Line[{{2,0},{5,0}}],
\t               Line[{{0,2},{2,2}}]
\t              }],
\t     Circuit3[],
\t     Graphics[{Text[FontForm[\"|f>\", {\"Symbol\",10}], {9.1,2}, {-1,0}],
\t               Text[FontForm[\"|f>\", {\"Symbol\",10}], {9.1,1}, {-1,0}],
\t               Text[FontForm[\"|y>\", {\"Symbol\",10}], {9.1,0}, {-1,0}]}],
\t     AliceBox[],
\t     BobBox[],
\t     AspectRatio->Automatic,
\t     PlotRange->{{-0.5, 9.6},{-0.7, 2.4}}]\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
AliceBox[]:=
\tGraphics[{AbsoluteThickness[1], Dashing[{0.01,0.01}],
\t          Line[{{0.125, -0.375},{0.125,2.375},{3.875,2.375},
\t                {3.875,-0.375},{0.125, -0.375}}
\t              ],
\t          Text[\"Alice\", {2,-0.6}]
\t         }]
\t         
BobBox[]:=
\tGraphics[{AbsoluteThickness[1], Dashing[{0.01,0.01}],
\t          Line[{{5.125, -0.375},{5.125,2.375},{8.875,2.375},
\t                {8.875,-0.375},{5.125, -0.375}}
\t              ],
\t          Text[\"Bob\", {7,-0.6}]
\t         }]\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
DrawOP[label_String, {x_, y_}]:=
\t{Line[{{x-0.25,y-0.25},
\t       {x-0.25,y+0.25},
\t       {x+0.25,y+0.25},
\t       {x+0.25,y-0.25},
\t       {x-0.25,y-0.25}}],
\t Text[FontForm[label,{\"Courier\",12}], {x,y}],
\t Line[{{x-0.5,  y}, {x-0.25,y}}],
\t Line[{{x+0.25, y}, {x+0.5, y}}]
\t}

DrawXOR[{x_, {y1_, y2_}}]:=
\tModule[{r},
\t\tr = 0.2;
\t\t{Circle[{x,y1}, r],
\t     AbsolutePointSize[6],
\t     Point[{x,y2}],
\t     Line[{{x,If[y1<y2,y1-r,y1+r]}, {x,y2}}],
\t     Line[{{x-0.5,y1},{x+0.5,y1}}],
\t     Line[{{x-0.5,y2},{x+0.5,y2}}]
\t    }
\t]
\t \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(label\)\" is similar to \
existing symbol \"\!\(Label\)\"."\)], "Message"]
}, Open  ]],

Cell["\<\
DrawOP[{x_, y_}, text_String]:=
\tGraphics[Line[{{x-0.5, y-0.5},
\t               {x+0.5, y-0.5},
\t               {x+0.5, y+0.5},
\t               {x-0.5, y+0.5},
\t               {x-0.5, y-0.5}}], Text[text, {x,y}]]\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Ancillary code in here ...", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Controlled-NOT Gate", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
aOP = {{0,1},   (* annihilation operator on a single bit *)
       {0,0}};
       
annihilationOP[i_, m_]:=
\tApply[Direct,
\t      ReplacePart[Table[IdentityMatrix[2], {m}], aOP, i]
\t     ]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
cOP = {{0,0},     (* creation operator that acts on a single bit *)
       {1,0}};

creationOP[i_, m_]:=
\tApply[Direct,
\t      ReplacePart[Table[IdentityMatrix[2], {m}], cOP, i]
\t     ]
\t\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CNGate[i_, j_, m_]:=
\t(creationOP[i,m] .
\t annihilationOP[i,m] . (annihilationOP[j,m] + creationOP[j,m]) +
\t annihilationOP[i,m] . creationOP[i,m]
\t)\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["State Vectors", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Converting Kets to Column Vectors", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
KetToColumnVector[ket[0]]:={{1},{0}}      (* spin up   = 0 *)
KetToColumnVector[ket[1]]:={{0},{1}}      (* spin down = 1 *)
KetToColumnVector[ket[bits__]]:=
\tApply[Direct, Map[KetToColumnVector[ket[#]]&, {bits}]]

KetToColumnVector[a_ ket_ket]:=
\ta KetToColumnVector[ket]
\t
KetToColumnVector[Plus[ket_, kets___]]:=
\tApply[Plus, Map[KetToColumnVector, {ket, kets}]]
\t
KetToColumnVector[superposition_]:=
\tKetToColumnVector[ Expand[superposition] ] \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(kets\)\" is similar to \
existing symbol \"\!\(ket\)\"."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Converting Bras to Row Vectors", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
BraToRowVector[bra[0]]:={{1,0}}
BraToRowVector[bra[1]]:={{0,1}}
BraToRowVector[w_. bra[bits__]]:=
\tw * Apply[Direct, Map[BraToRowVector[bra[#]]&, {bits}]]
BraToRowVector[w_. bra[bits__] + bras_.]:=
\tBraToRowVector[w * bra[bits]] + BraToRowVector[bras]
BraToRowVector[superposition_]:=
\tBraToRowVector[Expand[superposition]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(bras\)\" is similar to \
existing symbol \"\!\(bra\)\"."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Converting Column Vectors to Kets", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
ColumnVectorToKet[amplitudes_]:=
\tApply[Plus,
\t\t  MapThread[(#1[[1]] #2)&,
\t\t            {amplitudes,
\t\t             EigenKets[ Length[amplitudes] ]
\t\t            }
\t\t           ]
\t\t ]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Converting Row Vectors To Bras", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
RowVectorToBra[{{wi__}}]:=
\tModule[{eigenBras},
\t\teigenBras = EigenKets[Length[{wi}]] /. ket->bra;
\t\tApply[Plus, MapThread[(#1 #2)&, {{wi}, eigenBras}]]
\t]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Converting Between Bras and Kets", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
KetToBra[ket_]:=
\tRowVectorToBra[Conjugate[Transpose[KetToColumnVector[ket]]]]

BraToKet[bra_]:=
\tColumnVectorToKet[Conjugate[Transpose[BraToRowVector[bra]]]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Average Value of an Observable", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
ExpectationValue[w_. ket[bits__] + kets_., observable_]:=
\t(If[!HermitianQ[observable], 
\t\t(Message[ExpectationValue::notHermitian]; Abort[]),
\t\tIf[Length[observable] != 2^Length[{bits}],
\t\t   (Message[ExpectationValue::incompatible]; Abort[])]];
\t\t       
\t (BraToRowVector[KetToBra[w * ket[bits] + kets]] . 
\t  observable . 
\t  KetToColumnVector[w * ket[bits] + kets]
\t )[[1,1]]  (* scalar = a 1 x 1 matrix, [[1,1]] removes the parentheses *)
\t)

ExpectationValue[superposition_, observable_]:=
\tExpectationValue[Expand[superposition], observable]

ExpectationValue::notHermitian =
\t\"Your purported observable is not an Hermitian matrix.\";
ExpectationValue::incompatible =
\t\"The dimensions of the state vector and observable are incompatible.\";
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Eigenstates that Span a Hilbert Space", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
BasisEigenstates[m_Integer]:= EigenKets[2^m]

BasisEigenstates::usage = 
  \"BasisEigenstates[m] returns the complete set of \\
  eigenstates that span the Hilbert space of an m-bit \\
  quantum memory register.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
EigenKets[n_]:=
\tModule[{bits},
\t\tbits = Table[Apply[ket, IntegerDigits[i,2]], 
\t\t             {i, 0, n-1}];
\t\t          (* last eigenket has the most bits *)
\t\tMap[PadTo[Length[Last[bits]], #]&, bits]
\t]

PadTo[nDigits_, digits_]:=
\tJoin[Apply[ket, Table[0,{nDigits - Length[digits]}]], 
\t     digits]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Accessing Amplitudes of Superpositions and Computing \
Probabilities\
\>", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Options[Amplitudes] = {ShowEigenstates->False};

ShowEigenstates::usage = 
\t\"ShowEigenstates is an option for Amplitudes that \\
\tdetermines whether the 
output should be a list of the \\
\tamplitudes or a list of {eigenstate, 
amplitude} pairs.\";

Amplitudes[w_. ket[bits__] + kets_., opts___]:=
\tModule[{showeigen},
\tshoweigen = ShowEigenstates /. {opts} /. Options[Amplitudes];
\tWhich[showeigen == True, 
\t\t\tMap[{#, Coefficient[w ket[bits] + kets, #]}&,
\t\t        BasisEigenstates[ Length[{bits}] ]
\t\t       ],
\t\t  showeigen == False,
\t\t    Map[Coefficient[w ket[bits] + kets, #]&,
\t\t        BasisEigenstates[ Length[{bits}] ]
\t\t       ]
\t\t  ]
\t]

(* This clause catches cases like 1/Sqrt[2] (ket[0] + ket[1]) etc *)\t
Amplitudes[c_ (w_. ket[bits__] + kets_.)]:=
\tAmplitudes[ Expand[c (w ket[bits] + kets)] ]

Amplitudes::usage = 
  \"Amplitudes[superposition] returns the amplitudes of the \\
  eigenstates in a superposition or ket vectors.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(Amplitudes\)\" is \
similar to existing symbol \"\!\(amplitudes\)\"."\)], "Message"]
}, Open  ]],

Cell["\<\
Options[Probabilities] = {ShowEigenstates->False};

Probabilities[w_. ket[bits__] + kets_., opts___]:=
\tModule[{showeigen, amplitudes, symbols, sumOfSquares},
\t\tshoweigen    = ShowEigenstates /. {opts} /. Options[Probabilities];
\t\tamplitudes   = Amplitudes[w ket[bits] + kets];
\t\tsymbols      = SymbolicCoefficients[amplitudes]; (*see below*)
\t\tsumOfSquares = Simplify[
\t\t                Apply[Plus, 
\t\t                      Map[ComplexExpand[Abs[#]^2, symbols]&, 
\t\t                          amplitudes]]];
\t\tamplitudes   = If[sumOfSquares=!=1,  (* renormalize amplitudes
\t\t                                         if necessary *)
\t\t                  amplitudes/Sqrt[sumOfSquares],
\t\t                  amplitudes];
\t\tWhich[showeigen == True,  
\t\t       MapThread[{#1, ComplexExpand[Abs[#2]^2, symbols]}&, 
\t\t                 {BasisEigenstates[Length[{bits}]], amplitudes}
\t\t                ],
\t\t\t  showeigen == False, 
\t\t\t   Map[ComplexExpand[Abs[#]^2, symbols]&, amplitudes]
\t    ]
\t]

Probabilities[c_ (w_. ket[bits__] + kets_.)]:=
\tProbabilities[ Expand[c (w ket[bits] + kets)] ]

Probabilities::usage =
\t\"Probabilities[superposition] returns the probabilities of \\
\t finding a system in a state described by superposition in \\
\t each of its possible eigenstates upon being measured (observed). \\
\t If Probabilities is given the option ShowEigenstates->True \\
\t the function returns a list of {eigenstate, probability} pairs.\";\
\>", 
  "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
SymbolicCoefficients[amplitudes_List]:=
\tSelect[Union[Flatten[Map[Variables, amplitudes]]], 
\t\t   Not[MatchQ[#, Abs[_]]]&]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing Whether a Ket is Properly Normalized", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Needs[\"Algebra`ReIm`\"];

NormalizedKetQ[ket_]:=
\tModule[{columnVector},
\t\tcolumnVector = KetToColumnVector[ket];
\t\t(Inner[Times, 
\t\t       Conjugate[Transpose[columnVector]], 
               columnVector,
               Plus
              ] == {{1}} // N ) /. z_ Conjugate[z_] :> Abs[z]^2
    ]
   
NormalizedKetQ::usage =
\t\"NormalizedKetQ[ket] returns True if the square \\
\tmoduli of the amplitudes of the eigenkets in the \\
\tsuperposition \\\"ket\\\" sum to 1. If \\\"ket\\\" has non-numeric \\
\tamplitudes, the normalization cannot always be determined.\";\
\>", "Input",\

  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["NormalizeKet", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
NormalizeKet[superposition_]:=
\tsuperposition /; NormalizedKetQ[superposition]
NormalizeKet[superposition_]:=
\tExpand[superposition / 
\t       Sqrt[Apply[Plus, 
\t                  Map[Abs[#]^2&, 
\t                      Amplitudes[superposition, 
\t                                 ShowEigenstates->False]
\t                     ]
\t                 ]
\t           ]
\t]
\t      
NormalizeKet::usage =
\t\"NormalizeKet[superposition] is used to normalize a given \\
\tsuperposition of
 ket vectors. That is, if the sum of the squares \\
\tof the absolute values of 
the amplitudes of the eigenstates in \\
\tthe superposition do not sum to 1, 
NormalizeKet rescales the \\
\tamplitudes so that they squared moduli will sum 
to 1.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Direct Product", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
(* Last modified 09/07/96 *)
Needs[\"LinearAlgebra`MatrixManipulation`\"];

Direct[op1_, op2_]:=
\tBlockMatrix[Outer[Times, op1, op2]] /; MatrixQ[op1] && MatrixQ[op2]
\t
Direct[ket_, bra_]:=
\tDirect[KetToColumnVector[ket], BraToRowVector[bra]] /; IsKetQ[ket] && \
IsBraQ[
bra]
\t
Direct[ket1_, ket2_]:=
\tColumnVectorToKet[
\t\tDirect[KetToColumnVector[ket1],
\t           KetToColumnVector[ket2]]
\t]/; IsKetQ[ket1] && IsKetQ[ket2]

Direct[bra1_, bra2_]:=
\tRowVectorToBra[
\t\tDirect[BraToRowVector[bra1],
\t\t\t   BraToRowVector[bra2]]
\t] /; IsBraQ[bra1] && IsBraQ[bra2]
\t
Direct[bra_, ket_]:=
\t(Message[Direct::braket];
\t Direct[BraToRowVector[bra], KetToColumnVector[ket]]) /; IsBraQ[bra] && 
IsKetQ[ket]

Direct[bra_, op_]:=
\t(Message[Direct::braop];
\t Direct[BraToRowVector[bra], op]) /; IsBraQ[bra] && MatrixQ[op]
\t
Direct[op_, bra_]:=
\t(Message[Direct::opbra];
\t Direct[op, BraToRowVector[bra]]) /; MatrixQ[op] && IsBraQ[bra]
\t
Direct[ket_, op_]:=
\t(Message[Direct::ketop];
\t Direct[KetToColumnVector[ket], op]) /; IsKetQ[ket] && MatrixQ[op]
\t
Direct[op_, ket_]:=
\t(Message[Direct::opket];
\t Direct[op, KetToColumnVector[ket]]) /; MatrixQ[op] && IsKetQ[ket]

Direct[matrices__]:=
\tFold[Direct, First[{matrices}], Rest[{matrices}]]

Direct::braket =
\t\"Warning - You are taking the DIRECT product of a bra \\
\tand a ket. This is 
unusual. Perhaps you meant to use \\
\tthe DOT product?\";
\t
Direct::braop =
\t\"Warning - You are taking the DIRECT product of a bra \\
\twith an operator. 
This is unusual. Perhaps you meant to use \\
\tthe DOT product?\";
\t
Direct::opbra =
\t\"Warning - You are taking the DIRECT product of an operator \\
\twith a bra. 
This is unusual. Perhaps you meant to use \\
\tthe DOT product?\";

Direct::ketop =
\t\"Warning - You are taking the DIRECT product of a ket \\
\twith an operator. 
This is unusual. Perhaps you meant to use \\
\tthe DOT product?\";

Direct::opket =
\t\"Warning - You are taking the DIRECT product of an operator \\
\twith a ket. 
This is unusual. Perhaps you meant to use \\
\tthe DOT product?\";


IsKetQ[w_. ket[__] + kets_.]:= True
IsKetQ[_]:=False
\t
IsBraQ[w_. bra[__] + bras_.]:= True
IsBraQ[_]:=False\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Truth Table of a Logic Gate", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
TruthTable[gate_]:=
\tModule[{n,m},
\t\t{n,m} = Dimensions[gate];
\t\tWhich[Not[n==m && IntegerQ[n] && IntegerQ[m]],
\t\t      Message[TruthTable::notsquare]; Abort[],
\t\t      Not[IntegerQ[Log[2, n]]],
\t\t      Message[TruthTable::powerof2]; Abort[]
\t\t     ];
\t\tMap[(# -> ColumnVectorToKet[gate . KetToColumnVector[#]])&, 
\t\t    EigenKets[n]
\t\t   ]  // ColumnForm
\t]
\t
TruthTable::notsquare = 
  \"Your input is not a square matrix and cannot, therefore, represent a \\
  
reversible logic gate.\";

TruthTable::powerof2 = 
  \"Your input is not a matrix of dimensions (2^m) x (2^m) for integer m \\
  
and cannot, therefore, represent a reversible logic gate that operates \\
  on 
m bits.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Types of Operators (Matrices)", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
HermitianQ[matrix_]:=
\tmatrix == Conjugate[Transpose[matrix]]\
\>", "Input",
  AspectRatioFixed->True],

Cell["\<\
UnitaryQ[matrix_]:=
  Module[{rows, cols},
\t{rows, cols} = Dimensions[matrix];
\tIf[Not[IntegerQ[rows]] || 
\t   Not[IntegerQ[cols]] || 
\t   rows != cols, Message[UnitaryQ::notsquarematrix]];
\t
\t   Chop[Simplify[ComplexExpand[Conjugate[Transpose[matrix]]] - 
\t                 ComplexExpand[Inverse[matrix]]
\t                ]
\t       ] == ZeroMatrix[rows, cols]
  ]

UnitaryQ::notsquarematrix =
  \"Your input is not a square matrix.\";
  
ZeroMatrix[rows_, cols_]:=
\tTable[0, {rows}, {cols}]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tools for Making Test Superpositions", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
SymbolicSuperposition[m_]:=
\tApply[Plus,
\t      MapThread[(#1 #2)&, 
\t                {SymbolicAmplitudes[m], BasisEigenstates[m]}]
\t]
\t
SymbolicSuperposition::usage =
\t\"SymbolicSuperposition[m] creates a superposition of 2^m \\
\teigenstates whose
 amplitudes are uninstantiated symbols. These \\
\teigenstates represent the 
possible states of an m-bit memory \\
\tregister of a quantum computer. This 
function is useful for \\
\texploring the effects of quantum mechanical 
operations on \\
\tarbitrary superpositions. Note that the general form does not

\tguarentee that the superposition is normalized.\";
\t
SymbolicAmplitudes[m_]:=
\t(Clear[w];
\t Map[ToExpression[\"w\"<>ToString[#]]&, Table[i,{i,0,2^m - 1}]]
\t)\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Options[RandomSuperposition] = {Normalized->True};

RandomSuperposition[m_, opts___]:=
\tModule[{normalized},
\t\tnormalized = Normalized /. {opts} /. Options[RandomSuperposition];
\t\tsuperposition = Apply[Plus,
\t                          MapThread[(#1 #2)&, 
\t                                    {RandomAmplitudes[m],
\t                                     BasisEigenstates[m]}
\t                                   ]
\t                         ];
\t\tWhich[normalized==True, NormalizeKet[superposition],
\t          normalized==False, superposition
\t         ]
\t]

RandomSuperposition::usage =
\t\"RandomSuperposition[m] creates a normalized superposition \\
\tof 2^m eigenstates whose amplitudes are random complex numbers. \\
\tThese eigenstates represent the possible states of an m-bit \\
\tmemory register of a quantum computer. You can generate an \\
\tun-normalized superposition by setting the option Normalized->False.\";
\t
(* You can pick the amplitudes according to whatever distribution
   you like. In the current case we pick random complex numbers
   uniformly from the square in the complex plane bounded by a lower
   left corner at (-1,-I) and an upper right corner at (1,I).
*)
RandomAmplitudes[m_]:=
\tTable[Random[Complex, {-1-I, 1+I}], {2^m}]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(normalized\)\" is \
similar to existing symbol \"\!\(Normalized\)\"."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary State", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Options[ArbitraryState] = {Numeric->False};

ArbitraryState[m_, opts___]:=
\tModule[{coeffs, numericQ},
\t\tClear[w];
\t\tnumericQ = Numeric /. {opts} /. Options[ArbitraryState];
\t\tSwitch[numericQ, 
\t\t        True, RandomSuperposition[m],
\t\t        False, (coeffs = Table[c[i], {i,0,2^m -1}];
\t\t                Apply[Plus, 
\t\t                      MapThread[#1 #2&, 
\t\t                                {coeffs, BasisEigenstates[m]}]]
\t\t               )
\t\t      ]
\t]\
\>", "Input",
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantum Memory Registers", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["ReadMemoryRegister", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
(*====================*)
(* ReadMemoryRegister *)
(*====================*)
(* Given a superposition representing the state of the memory of a
   quantum computer, return the result of measuring the memory.
*)
Options[ReadMemoryRegister] = {TraceProgress->False};

ReadMemoryRegister[w_. ket[bits__] + kets_., opts___]:=
\tModule[{nBits, superposition, resultsPerStep, traceQ},
\t\ttraceQ = TraceProgress /. {opts} /. Options[ReadMemoryRegister];
\t\tnBits = Length[{bits}]; (* figure out number of bits in memory *)
\t\tsuperposition = {\"BeforeAnyMeasurements\", w ket[bits] + kets};
\t\tresultsPerStep = FoldList[MeasureIthBit[#2,#1,nBits]&,
\t\t                          superposition,
\t\t                          Range[nBits]
\t\t                         ];
\t\tWhich[traceQ===False, 
\t\t        {Rest[Map[#[[1]]&, resultsPerStep]],  (* results for bits *)
\t\t         Last[resultsPerStep][[2]]            (* projected state *)
\t\t        },
\t\t      traceQ===True,
\t\t        ColumnForm[resultsPerStep] (*list of {results,projectedStates}*)
\t\t     ]
\t]
\t
ReadMemoryRegister::usage =
\t\"ReadMemoryRegister[superposition] reads the state of each bit \\
\tin the memory register. As the i-th and j-th bit measurement \\
\toperators commute (for any i and j), it does not matter in what \\
\torder you measure the bits.\";
\t\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["MeasureIthBit", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
MeasureIthBit[i_, {_, superposition_}, nBits_]:=
\tModule[{p1, zeroOrOne, projectedState},
\t\tp1 = ProbabilityIthBitIs1[i, superposition];
\t\tzeroOrOne = BiasedSelect[{0,1}, {1-p1, p1}];
\t\tprojectedState = 
\t\t  SuperpositionWithIthBitFixed[i, zeroOrOne, nBits, superposition];
\t\t{zeroOrOne, projectedState}
\t]
\t\t       
KetWithIthBitZeroOrOne[i_, zeroOrOne_, nBits_]:=
\tReplacePart[Apply[ket, Table[_,{nBits}]], zeroOrOne, i]

SuperpositionWithIthBitFixed[_, _, _, w_. ket[bits__]]:=
  NormalizeKet[w ket[bits]]
SuperpositionWithIthBitFixed[i_, zeroOrOne_, nBits_, superposition_]:=
  NormalizeKet[Select[superposition,
\t\t              MatchQ[#, _. KetWithIthBitZeroOrOne[i,zeroOrOne,nBits]
\t\t                    ]&
\t\t             ]
\t\t      ]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["ProbabilityIthBitIs1", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
ProbabilityIthBitIs1[i_, w_. ket[bits__]]:=
\tIf[ket[bits][[i]] == 1, Abs[w]^2, 1-Abs[w]^2]  (* Abs[w]^2 == 1 or 0 only \
*)
\t
ProbabilityIthBitIs1[i_, w_. ket[bits__] + kets_.]:=
\tModule[{nBits, terms},
\t\tnBits = Length[{bits}];
\t\tterms = Select[w ket[bits] + kets, 
\t\t               MatchQ[#, _. KetWithIthBit1[i,nBits]]&];
\t\tN[Apply[Plus, Map[Abs[#]^2&, Amplitudes[terms]]]/
\t\t  Apply[Plus, Map[Abs[#]^2&, Amplitudes[w ket[bits] + kets]]]
\t\t ]
\t]
\t
ProbabilityIthBitIs1[i_, c_. (w_. ket[bits__] + kets_.)]:=
\tProbabilityIthBitIs1[i, Expand[c (w ket[bits] + kets)]]

ProbabilityIthBitIs1::usage =
\t\"The state of the memory register of a quantum computer \\
\t(that is comprised of m 2-state particles) is represented by a \\
\tsuperposition 2^m eigenstates. The function \\
\tProbabilityIthBitIs1[i, superposition] computes the probability \\
\tthat, upon being measured, the i-th, of the m, bits will be a 1.\";
\t
KetWithIthBit1[i_, nBits_]:=
\tReplacePart[Apply[ket, Table[_,{nBits}]], 1, i]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["BiasedSelect", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
(* The list of probabilities should sum to 1. The call to Partition \

   constructs a set of probability intervals whose width is proportional
   to the probability with which the corresponding element in list 
   is selected.
*)
BiasedSelect[list_, probabilities_]:=
\tModule[{random},
\t\trandom  = Random[];
\t\tApply[Part[list, #]&,
\t\t      Flatten[
\t\t       Position[Map[InRangeQ[random, #]&, 
\t\t                    Partition[FoldList[Plus,0,probabilities],2,1]
\t\t                   ],
\t\t                True
\t\t       ]
\t\t      ]
\t\t     ]
\t] (* /;CheckProbabilitiesQ[probabilities] *)

BiasedSelect::usage =
\t\"BiasedSelect[{e1,e2,...,en}, {p1,p2,...,pn}] returns element ei of \\
\tthe first list with probability given in the second list pi.\";

BiasedSelect::probabilityLeak =
\t\"You have a probability leak. The probabilities you specified do \\
\tnot add up to 1.\";

BiasedSelect::excess =
\t\"The probabilities you specified sum to greater than 1.\";

CheckProbabilitiesQ[probabilities_]:=
\tModule[{psum = Apply[Plus, probabilities]},
\t\tWhich[psum<1,  Message[BiasedSelect::probabilityLeak],
\t\t      psum>1,  Message[BiasedSelect::excess],
\t\t      psum==1, True
\t\t     ]
\t]
\t
InRangeQ[n_, {lb_, 1}]:=   lb <= n <= 1
InRangeQ[n_, {lb_, ub_}]:= lb <= n < ub\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(list\)\" is similar to \
existing symbol \"\!\(List\)\"."\)], "Message"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(probabilities\)\" is \
similar to existing symbol \"\!\(Probabilities\)\"."\)], "Message"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(random\)\" is similar \
to existing symbol \"\!\(Random\)\"."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\(General :: \"spell1\"\) will be suppressed \
during this calculation."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReadPartOfMemoryRegister", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
(*==========================*)
(* ReadPartOfMemoryRegister *)
(*==========================*)
(* Given a superposition representing the state of the memory of a
   quantum computer, return the result of measuring a specific
   subset of the qubits in the memory.
   
   >>> This function is used in error correcting codes <<<
*)
Options[ReadPartOfMemoryRegister] = {TraceProgress->False};

ReadPartOfMemoryRegister[w_. ket[bits__] + kets_., bitsToRead_, opts___]:=
\tModule[{nBits, superposition, resultsPerStep, traceQ},
\t\ttraceQ = TraceProgress /. {opts} /. Options[ReadPartOfMemoryRegister];
\t\tnBits = Length[{bits}]; (* figure out number of bits in memory *)
\t\tsuperposition = {\"BeforeAnyMeasurements\", w ket[bits] + kets};
\t\tresultsPerStep = FoldList[MeasureIthBit[#2,#1,nBits]&,
\t\t                          superposition,
\t\t                          bitsToRead
\t\t                         ];
\t\tWhich[traceQ===False, 
\t\t        {Rest[Map[#[[1]]&, resultsPerStep]],  (* results for bits *)
\t\t         Last[resultsPerStep][[2]]            (* projected state *)
\t\t        },
\t\t      traceQ===True,
\t\t        ColumnForm[resultsPerStep] (*list of {results,projectedStates}*)
\t\t     ]
\t]
\t
ReadPartOfMemoryRegister::usage =
\t\"ReadPartOfMemoryRegister[superposition, bitsToRead] reads the state \\
\tof selected bits in the memory register. As the i-th and j-th bit \\
\tmeasurement operators commute (for any i and j), it does not matter \\
\tin what order you measure the bits.\";\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{578, 369},
WindowMargins->{{Automatic, 18}, {11, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 105, 3, 98, "Title",
  Evaluatable->False],
Cell[1839, 56, 107, 3, 53, "Subsubtitle",
  Evaluatable->False],
Cell[1949, 61, 20180, 489, 112, 3754, 280, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[22132, 552, 72, 2, 25, "Input"],

Cell[CellGroupData[{
Cell[22229, 558, 102, 3, 50, "Section",
  Evaluatable->False],
Cell[22334, 563, 905, 19, 222, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[23276, 587, 115, 3, 50, "Section",
  Evaluatable->False],
Cell[23394, 592, 1847, 29, 302, "Text",
  Evaluatable->False],
Cell[25244, 623, 1165, 19, 174, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[26446, 647, 103, 2, 50, "Section",
  Evaluatable->False],
Cell[26552, 651, 959, 15, 158, "Text",
  Evaluatable->False],
Cell[27514, 668, 20161, 488, 112, 3754, 280, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[47678, 1158, 144, 5, 30, "Text",
  Evaluatable->False],
Cell[47825, 1165, 62, 7, 77, "Input"],
Cell[47890, 1174, 499, 10, 94, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[48414, 1188, 105, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[48522, 1192, 167, 5, 30, "Text",
  Evaluatable->False],
Cell[48692, 1199, 236, 11, 116, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[48965, 1215, 157, 5, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[49147, 1224, 617, 22, 311, "Input",
  InitializationCell->True],
Cell[49767, 1248, 173, 3, 37, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49989, 1257, 81, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[50095, 1263, 192, 10, 103, "Input",
  InitializationCell->True],
Cell[50290, 1275, 173, 3, 37, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50512, 1284, 94, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[50609, 1288, 439, 9, 78, "Text",
  Evaluatable->False],
Cell[51051, 1299, 20161, 488, 112, 3754, 280, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71261, 1793, 113, 2, 50, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[71399, 1799, 103, 2, 46, "Subsection",
  Evaluatable->False],
Cell[71505, 1803, 793, 14, 174, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[72323, 1821, 62, 1, 25, "Input"],
Cell[72388, 1824, 6854, 162, 121, 1200, 87, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[79257, 1989, 339, 8, 78, "Text",
  Evaluatable->False],
Cell[79599, 1999, 788, 14, 174, "Text",
  Evaluatable->False],
Cell[80390, 2015, 199, 7, 77, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[80614, 2026, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[80697, 2030, 153, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[80875, 2039, 75, 4, 38, "Input"],
Cell[80953, 2045, 65, 1, 48, "Output"]
}, Open  ]],
Cell[81033, 2049, 805, 13, 126, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[81887, 2068, 109, 2, 46, "Subsection",
  Evaluatable->False],
Cell[81999, 2072, 529, 10, 94, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[82553, 2086, 79, 1, 25, "Input"],
Cell[82635, 2089, 10276, 232, 170, 1589, 120, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[92914, 2323, 131, 7, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[93060, 2333, 231, 6, 46, "Text",
  Evaluatable->False],
Cell[93294, 2341, 243, 9, 90, "Input",
  InitializationCell->True],
Cell[93540, 2352, 173, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[93738, 2361, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[93843, 2367, 86, 1, 25, "Input"],
Cell[93932, 2370, 237, 3, 72, "Output"]
}, Open  ]],
Cell[94184, 2376, 330, 8, 78, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[94539, 2388, 89, 1, 25, "Input"],
Cell[94631, 2391, 211, 6, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[94891, 2403, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[94974, 2407, 106, 2, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[95105, 2413, 117, 4, 25, "Input"],
Cell[95225, 2419, 292, 4, 53, "Output"]
}, Open  ]],
Cell[95532, 2426, 178, 5, 30, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95759, 2437, 108, 2, 46, "Subsection",
  Evaluatable->False],
Cell[95870, 2441, 329, 7, 62, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[96224, 2452, 68, 1, 25, "Input"],
Cell[96295, 2455, 281, 4, 67, "Print"]
}, Open  ]],
Cell[96591, 2462, 356, 7, 62, "Text",
  Evaluatable->False],
Cell[96950, 2471, 135, 5, 38, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[97110, 2480, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[97215, 2486, 92, 1, 25, "Input"],
Cell[97310, 2489, 103, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[97462, 2497, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[97545, 2501, 115, 2, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[97685, 2507, 68, 1, 25, "Input"],
Cell[97756, 2510, 35, 1, 25, "Output"]
}, Open  ]],
Cell[97806, 2514, 104, 2, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[97935, 2520, 68, 1, 25, "Input"],
Cell[98006, 2523, 35, 1, 25, "Output"]
}, Open  ]],
Cell[98056, 2527, 262, 6, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[98343, 2537, 64, 1, 25, "Input"],
Cell[98410, 2540, 90, 1, 25, "Output"]
}, Open  ]],
Cell[98515, 2544, 230, 6, 46, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[98782, 2555, 94, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[98879, 2559, 467, 13, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[99371, 2576, 117, 4, 25, "Input"],
Cell[99491, 2582, 1544, 49, 81, "Output"]
}, Open  ]],
Cell[101050, 2634, 428, 13, 68, "Text",
  Evaluatable->False],
Cell[101481, 2649, 654, 11, 110, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[102160, 2664, 51, 1, 25, "Input"],
Cell[102214, 2667, 35, 1, 25, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102286, 2673, 51, 1, 25, "Input"],
Cell[102340, 2676, 35, 1, 25, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102412, 2682, 49, 1, 25, "Input"],
Cell[102464, 2685, 90, 1, 25, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[102615, 2693, 88, 2, 46, "Subsection",
  Evaluatable->False],
Cell[102706, 2697, 352, 7, 62, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[103083, 2708, 56, 1, 25, "Input"],
Cell[103142, 2711, 9883, 236, 118, 1647, 129, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[113040, 2950, 86, 2, 30, "Text",
  Evaluatable->False],
Cell[113129, 2954, 400, 16, 194, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[113554, 2974, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[113659, 2980, 90, 1, 25, "Input"],
Cell[113752, 2983, 90, 1, 25, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113879, 2989, 68, 1, 25, "Input"],
Cell[113950, 2992, 78, 1, 25, "Output"]
}, Open  ]],
Cell[114043, 2996, 155, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[114223, 3005, 55, 1, 25, "Input"],
Cell[114281, 3008, 211, 6, 25, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114565, 3022, 87, 2, 50, "Section",
  Evaluatable->False],
Cell[114655, 3026, 161, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[114841, 3035, 52, 1, 25, "Input"],
Cell[114896, 3038, 158, 2, 37, "Print"]
}, Open  ]],
Cell[115069, 3043, 20180, 489, 112, 3754, 280, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[135274, 3536, 119, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[135396, 3540, 236, 9, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[135657, 3553, 3011, 77, 70, "Input",
  InitializationCell->True],
Cell[138671, 3632, 265, 4, 70, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138973, 3641, 52, 1, 70, "Input"],
Cell[139028, 3644, 3095, 66, 70, "Print",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[142172, 3716, 80, 2, 28, "Subsubsection",
  Evaluatable->False],
Cell[142255, 3720, 565, 19, 48, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[142845, 3743, 78, 1, 25, "Input"],
Cell[142926, 3746, 171, 3, 25, "Output"]
}, Open  ]],
Cell[143112, 3752, 192, 5, 46, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[143341, 3762, 80, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[143446, 3768, 65, 1, 25, "Input"],
Cell[143514, 3771, 538, 13, 37, "Print"],
Cell[144055, 3786, 83, 1, 52, "Print"],
Cell[144141, 3789, 42, 1, 22, "Print"],
Cell[144186, 3792, 108, 2, 37, "Print"],
Cell[144297, 3796, 87, 1, 52, "Print"],
Cell[144387, 3799, 42, 1, 22, "Print"],
Cell[144432, 3802, 108, 2, 37, "Print"],
Cell[144543, 3806, 71, 1, 22, "Print"],
Cell[144617, 3809, 88, 1, 22, "Print"],
Cell[144708, 3812, 41, 1, 22, "Print"],
Cell[144752, 3815, 41, 1, 22, "Print"],
Cell[144796, 3818, 55, 1, 22, "Print"],
Cell[144854, 3821, 92, 1, 22, "Print"],
Cell[144949, 3824, 839, 16, 67, "Print"],
Cell[145791, 3842, 37, 1, 37, "Print"],
Cell[145831, 3845, 42, 1, 22, "Print"],
Cell[145876, 3848, 282, 7, 37, "Print"],
Cell[146161, 3857, 107, 2, 52, "Print"],
Cell[146271, 3861, 42, 1, 22, "Print"],
Cell[146316, 3864, 97, 2, 22, "Print"],
Cell[146416, 3868, 105, 2, 37, "Print"],
Cell[146524, 3872, 102, 2, 22, "Print"],
Cell[146629, 3876, 84, 1, 22, "Print"],
Cell[146716, 3879, 206, 3, 22, "Print"],
Cell[146925, 3884, 39, 1, 52, "Print"],
Cell[146967, 3887, 42, 1, 22, "Print"],
Cell[147012, 3890, 63, 1, 22, "Print"],
Cell[147078, 3893, 42, 1, 22, "Print"],
Cell[147123, 3896, 46, 1, 22, "Print"],
Cell[147172, 3899, 100, 2, 22, "Print"],
Cell[147275, 3903, 76, 1, 22, "Print"],
Cell[147354, 3906, 103, 2, 22, "Print"],
Cell[147460, 3910, 77, 1, 22, "Print"],
Cell[147540, 3913, 88, 1, 22, "Print"],
Cell[147631, 3916, 104, 2, 22, "Print"],
Cell[147738, 3920, 88, 1, 22, "Print"],
Cell[147829, 3923, 53, 1, 22, "Print"],
Cell[147885, 3926, 127, 2, 37, "Print"],
Cell[148015, 3930, 171, 3, 25, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148247, 3940, 95, 2, 50, "Section",
  Evaluatable->False],
Cell[148345, 3944, 1137, 42, 70, "Input",
  InitializationCell->True],
Cell[149485, 3988, 474, 11, 70, "Input",
  InitializationCell->True],
Cell[149962, 4001, 424, 11, 70, "Input",
  InitializationCell->True],
Cell[150389, 4014, 1115, 23, 70, "Input"],
Cell[151507, 4039, 564, 17, 70, "Input"],

Cell[CellGroupData[{
Cell[152096, 4060, 638, 26, 70, "Input",
  InitializationCell->True],
Cell[152737, 4088, 177, 3, 70, "Message"]
}, Open  ]],
Cell[152929, 4094, 268, 8, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[153234, 4107, 93, 2, 30, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[153352, 4113, 92, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[153447, 4117, 270, 10, 70, "Input",
  InitializationCell->True],
Cell[153720, 4129, 270, 11, 70, "Input",
  InitializationCell->True],
Cell[153993, 4142, 232, 8, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[154262, 4155, 83, 2, 70, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[154370, 4161, 106, 2, 70, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[154501, 4167, 532, 16, 70, "Input",
  InitializationCell->True],
Cell[155036, 4185, 174, 3, 70, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[155259, 4194, 103, 2, 70, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[155387, 4200, 405, 11, 70, "Input",
  InitializationCell->True],
Cell[155795, 4213, 174, 3, 70, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[156018, 4222, 106, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[156127, 4226, 276, 11, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[156440, 4242, 103, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[156546, 4246, 240, 8, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[156823, 4259, 105, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[156931, 4263, 239, 8, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[157207, 4276, 103, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[157313, 4280, 847, 23, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[158197, 4308, 119, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[158319, 4312, 293, 9, 70, "Input",
  InitializationCell->True],
Cell[158615, 4323, 393, 14, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[159045, 4342, 149, 5, 70, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[159219, 4351, 1053, 33, 70, "Input",
  InitializationCell->True],
Cell[160275, 4386, 187, 3, 70, "Message"]
}, Open  ]],
Cell[160477, 4392, 1564, 37, 70, "Input",
  InitializationCell->True],
Cell[162044, 4431, 204, 6, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[162285, 4442, 117, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[162405, 4446, 656, 21, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[163098, 4472, 85, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[163186, 4476, 815, 26, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[164038, 4507, 87, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[164128, 4511, 2269, 86, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[166434, 4602, 100, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[166537, 4606, 785, 27, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[167359, 4638, 102, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[167464, 4642, 113, 4, 70, "Input"],
Cell[167580, 4648, 580, 21, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[168197, 4674, 109, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[168309, 4678, 809, 27, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[169143, 4709, 1350, 33, 70, "Input",
  InitializationCell->True],
Cell[170496, 4744, 187, 3, 70, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[170732, 4753, 88, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[170823, 4757, 532, 17, 70, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[171404, 4780, 94, 2, 70, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[171523, 4786, 91, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[171617, 4790, 1417, 35, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[173071, 4830, 86, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[173160, 4834, 841, 23, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[174038, 4862, 93, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[174134, 4866, 1094, 29, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[175265, 4900, 85, 2, 70, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[175375, 4906, 1377, 44, 70, "Input",
  InitializationCell->True],
Cell[176755, 4952, 175, 3, 70, "Message"],
Cell[176933, 4957, 193, 3, 70, "Message"],
Cell[177129, 4962, 179, 3, 70, "Message"],
Cell[177311, 4967, 161, 3, 70, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[177521, 4976, 97, 2, 70, "Subsubsection",
  Evaluatable->False],
Cell[177621, 4980, 1591, 37, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

